#pragma once
#include "HSBColor.h"
#include <gdiplus.h>
#include <agg_color_rgba.h>

#define C_CHUESATCTRL_CLASSNAME _T("MFCHueSatCtrl")

// CHueSatCtrl

class CHueSatCtrl : public CWnd
{
	DECLARE_DYNAMIC(CHueSatCtrl)

public:
	CHueSatCtrl();
	virtual ~CHueSatCtrl();
    void SetHueSat(double hue, double sat);
    void GetHueSat(double& hue, double& sat);
    enum {RectSize = 5, HS_CHANGE = 3456};

protected:
    bool mInitialized;
    double mHue;
    double mSat;
    double mRadius;
    bool mDrawMarker;
    bool mIgnoreMouseMove;
    Gdiplus::Pen mBlackPen;
    Gdiplus::Rect mHSrect;
    Gdiplus::Rect mFocusRect;
    Gdiplus::Point mHScenter;
    Gdiplus::Rect mCurrentHSrect;
    Gdiplus::Bitmap* mHSbitmap;
    Gdiplus::Pen* mFocusPen;
    Gdiplus::Pen* mNoFocusPen;
    HCURSOR mMarkerCursor;
    HCURSOR mPrevCursor;
    NMHDR mNotify;
    void CalcRect();
    void Init();
    void TrackPoint(CPoint p);
    void RedrawPoint(BOOL erase);
    BOOL RegisterWindowClass();
    void DrawFocus(Gdiplus::Pen* p);
    afx_msg void OnPaint();
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnSetFocus(CWnd*);
    afx_msg void OnKillFocus(CWnd*);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg UINT OnGetDlgCode();

	DECLARE_MESSAGE_MAP()
};


