////////////////////////////////////////////////////////////////
// MSDN -- August 2000
// If this code works, it was written by Paul DiLascia.
// If not, I don't know who wrote it.
// Compiles with Visual C++ 6.0, runs on Windows 98 and probably NT too.
//
#pragma once

// Windows 2000 version of OPENFILENAME.
// The new version has three extra members.
// This is copied from commdlg.h
//
struct OPENFILENAMEEX : public OPENFILENAME { 
  void *        pvReserved;
  DWORD         dwReserved;
  DWORD         FlagsEx;
};

class qtCanvas;

/////////////////////////////////////////////////////////////////////////////
// CFileDialogEx: Encapsulate Windows-2000 style open dialog.
//
class CFileDialogEx : public CFileDialog {
	DECLARE_DYNAMIC(CFileDialogEx)
public:
    enum LengthUnits {Inval = -1, Seconds = 0, Frames = 1};
	CFileDialogEx(bool movieFile,
        BOOL bOpenFileDialog, // TRUE for open, FALSE for FileSaveAs
		LPCTSTR lpszDefExt = NULL,
		LPCTSTR lpszFileName = NULL,
		DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		LPCTSTR lpszFilter = NULL,
		CWnd* pParentWnd = NULL);

	// override
	virtual int DoModal();
    qtCanvas*   mQTCanvas;
    bool        mTiled;
    bool        mIsRect;
    int         mTileType;

protected:
    int         mUnitsSeconds;
    int         mUnitsFrames;
    int         mUnits;
    int         mLength;
    bool        mZoom;
    bool        mCropped;
    bool        mEmbedCFDG;
    int         mJPEGQuality;
protected:
	OPENFILENAMEEX m_ofnEx;	// new Windows 2000 version of OPENFILENAME
    CComboBox*  mUnitsCtrl;
    CButton*    mZoomCtrl;
    CButton*    mCropCtrl;
    CButton*    mEmbedCtrl;
    CButton*    mUnitTileCtrl;
    CButton*    mRectTileCtrl;
    bool        mMovieFile;
    CSliderCtrl* mQualCtrl;
    CStatic*    mQualText;
    virtual void OnTypeChange();
    void        updateCtrls();

	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
    void FakeOnOK();

	DECLARE_MESSAGE_MAP()
	//{{AFX_MSG(CFileDialogEx)
	afx_msg void OnMovieSettings();
    afx_msg void OnDestroy();
    BOOL OnInitDialog();
	//}}AFX_MSG
};
