////////////////////////////////////////////////////////////////
// MSDN -- August 2000
// If this code works, it was written by Paul DiLascia.
// If not, I don't know who wrote it.
// Largely based on original implementation by Michael Lemley.
// Compiles with Visual C++ 6.0, runs on Windows 98 and probably NT too.
//
// CFileDialogEx implements a CFileDialog that uses the new Windows
// 2000 style open/save dialog. Use companion class CDocManagerEx in an
// MFC framework app.
//
#include "stdafx.h"
#include <afxpriv.h>
#include "FileDialogEx.h"
#include "resource.h"
#include "qtCanvas.h"
#include "ContextFree.h"
#include "RenderOptions.h"

extern CContextFreeApp theApp;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static BOOL IsWin2000();

IMPLEMENT_DYNAMIC(CFileDialogEx, CFileDialog)

CFileDialogEx::CFileDialogEx(bool movieFile, BOOL bOpenFileDialog, LPCTSTR lpszDefExt,
	LPCTSTR lpszFileName, DWORD dwFlags, LPCTSTR lpszFilter, CWnd* pParentWnd) :
	CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName,
		dwFlags, lpszFilter, pParentWnd), mQTCanvas(0), mTiled(false), 
        mIsRect(true), mTileType(0), mUnitsCtrl(0),
        mZoomCtrl(0), mCropCtrl(0), mEmbedCtrl(0), mUnitTileCtrl(0),
        mRectTileCtrl(0), mMovieFile(movieFile)
{
	m_ofn.Flags |= OFN_ENABLETEMPLATE;
	m_ofn.hInstance = AfxGetResourceHandle();
    if (IsWin2000()) {
        m_ofn.lpTemplateName = 
            MAKEINTRESOURCE(movieFile ? IDD_CUSTOM_TEMPLATE_NT : IDD_SAVEIMAGE_TEMPLATE_NT);
    } else {
        m_ofn.lpTemplateName = 
            MAKEINTRESOURCE(movieFile ? IDD_CUSTOM_TEMPLATE_98 : IDD_SAVEIMAGE_TEMPLATE_98);
    }
}


BEGIN_MESSAGE_MAP(CFileDialogEx, CFileDialog)
	//{{AFX_MSG_MAP(CFileDialogEx)
	ON_BN_CLICKED(IDC_MOVIE_SETTINGS, OnMovieSettings)
    ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CFileDialogEx::OnInitDialog()
{
    CFileDialog::OnInitDialog();

    if (mMovieFile) {
        mZoom = theApp.getPrefZoom();
        mLength = theApp.getPrefLength();
        mUnits = theApp.getPrefLengthUnits();

        mUnitsCtrl = (CComboBox*)GetDlgItem(IDC_LENGTH_UNITS);
        mZoomCtrl = (CButton*)GetDlgItem(IDC_MOVIE_ZOOM);
        
        mUnitsSeconds = mUnitsCtrl->AddString(_T("Seconds"));
        mUnitsFrames = mUnitsCtrl->AddString(_T("Frames"));
        
        mUnitsCtrl->SetCurSel(mUnits == Seconds ? mUnitsSeconds : mUnitsFrames);
        
        SetDlgItemInt(IDC_MOVIE_LENGTH, mLength, FALSE);
        mZoomCtrl->SetCheck(mZoom);
    } else {
        mCropped = theApp.getPrefCrop();
        mJPEGQuality = theApp.getPrefJPEGqual();
        mEmbedCFDG = theApp.getPrefEmbedCFDG();

        mCropCtrl = (CButton*)GetDlgItem(IDC_IMAGE_CROP);
        mCropCtrl->SetCheck(mCropped ? 1 : 0);

        mEmbedCtrl = (CButton*)GetDlgItem(IDC_IMAGE_EMBED);
        mEmbedCtrl->SetCheck(mEmbedCFDG ? 1 : 0);

        mQualCtrl = (CSliderCtrl*)GetDlgItem(IDC_JPG_QUALITY);
        mQualText = (CStatic*)GetDlgItem(IDT_JPG_QUALITY);
        mQualCtrl->SetRange(0, 100, FALSE);
        mQualCtrl->SetPos(mJPEGQuality);

        mUnitTileCtrl = (CButton*)GetDlgItem(IDC_SAVE_UNIT_TILE);
        mRectTileCtrl = (CButton*)GetDlgItem(IDC_SAVE_RECT_TILE);
        if (!mIsRect || mTileType == 0)
            mUnitTileCtrl->SetCheck(1);
        else 
            mRectTileCtrl->SetCheck(1);
        mRectTileCtrl->EnableWindow(mIsRect);

        mCropCtrl->ShowWindow(mTiled ? SW_HIDE : SW_SHOW);
        mUnitTileCtrl->ShowWindow(mTiled ? SW_SHOW : SW_HIDE);
        mRectTileCtrl->ShowWindow(mTiled ? SW_SHOW : SW_HIDE);
    }

    updateCtrls();
    return TRUE;
}

void CFileDialogEx::updateCtrls()
{
    if (!mMovieFile) {
        mQualCtrl->EnableWindow(m_ofn.nFilterIndex == 3);
        mQualText->EnableWindow(m_ofn.nFilterIndex == 3);
    }
}

void CFileDialogEx::OnDestroy()
{
    if (mMovieFile) {
        mUnits = mUnitsCtrl->GetCurSel() == mUnitsSeconds ? Seconds : Frames;
        mLength = GetDlgItemInt(IDC_MOVIE_LENGTH, NULL, FALSE);
        mZoom = mZoomCtrl->GetCheck() == 1;
    } else {
        mCropped = mCropCtrl->GetCheck() == 1;
        mEmbedCFDG = mEmbedCtrl->GetCheck() == 1;
        mJPEGQuality = mQualCtrl->GetPos();
        mTileType = mUnitTileCtrl->GetCheck() == 1 ? 0 : 1;
    }

    CFileDialog::OnDestroy();
}

// MFC doesn't provide an OnOK() virtual method for CFileDialog so there is no
// direct way to know when to save the extended control information back to the
// user prefs area. So we fake it by overriding DoModal() and checking the 
// return value of CFileDialog::DoModal()
void CFileDialogEx::FakeOnOK() 
{
    if (mMovieFile) {
        theApp.setPrefZoom(mZoom);
        theApp.setPrefLength(mLength);
        theApp.setPrefLengthUnits(mUnits);
    } else {
        theApp.setPrefCrop(mCropped);
        theApp.setPrefEmbedCFDG(mEmbedCFDG);
        theApp.setPrefJPEGqual(mJPEGQuality);
    }
}

void CFileDialogEx::OnMovieSettings() 
{
    mQTCanvas->showSettingsDialog();
}

BOOL IsWin2000() 
{
   OSVERSIONINFOEX osvi;
   BOOL bOsVersionInfoEx;

   // Try calling GetVersionEx using the OSVERSIONINFOEX structure,
   // which is supported on Windows 2000.
   //
   // If that fails, try using the OSVERSIONINFO structure.

   ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));
   osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

   bOsVersionInfoEx = GetVersionEx ((OSVERSIONINFO *) &osvi);
   if( !bOsVersionInfoEx )
   {
      // If OSVERSIONINFOEX doesn't work, try OSVERSIONINFO.

      osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
      if (! GetVersionEx ( (OSVERSIONINFO *) &osvi) ) 
         return FALSE;
   }

   switch (osvi.dwPlatformId)
   {
      case VER_PLATFORM_WIN32_NT:

         if ( osvi.dwMajorVersion >= 5 )
            return TRUE;

         break;
   }
   return FALSE; 
}

//////////////////
// DoModal override copied mostly from MFC, with modification to use
// m_ofnEx instead of m_ofn.
//
int CFileDialogEx::DoModal()
{
#ifndef VC6
    int retVal = CFileDialog::DoModal();
    if (retVal == IDOK)
        FakeOnOK();
    return retVal;
#else
	ASSERT_VALID(this);
	ASSERT(m_ofn.Flags & OFN_ENABLEHOOK);
	ASSERT(m_ofn.lpfnHook != NULL); // can still be a user hook

	// zero out the file buffer for consistent parsing later
	ASSERT(AfxIsValidAddress(m_ofn.lpstrFile, m_ofn.nMaxFile));
	DWORD nOffset = lstrlen(m_ofn.lpstrFile)+1;
	ASSERT(nOffset <= m_ofn.nMaxFile);
	memset(m_ofn.lpstrFile+nOffset, 0, (m_ofn.nMaxFile-nOffset)*sizeof(TCHAR));

	// WINBUG: This is a special case for the file open/save dialog,
	//  which sometimes pumps while it is coming up but before it has
	//  disabled the main window.
	HWND hWndFocus = ::GetFocus();
	BOOL bEnableParent = FALSE;
	m_ofn.hwndOwner = PreModal();
	AfxUnhookWindowCreate();
	if (m_ofn.hwndOwner != NULL && ::IsWindowEnabled(m_ofn.hwndOwner))
	{
		bEnableParent = TRUE;
		::EnableWindow(m_ofn.hwndOwner, FALSE);
	}

	_AFX_THREAD_STATE* pThreadState = AfxGetThreadState();
	ASSERT(pThreadState->m_pAlternateWndInit == NULL);

	if (m_ofn.Flags & OFN_EXPLORER)
		pThreadState->m_pAlternateWndInit = this;
	else
		AfxHookWindowCreate(this);

	memset(&m_ofnEx, 0, sizeof(m_ofnEx));
	memcpy(&m_ofnEx, &m_ofn, sizeof(m_ofn));
   if (IsWin2000())
	   m_ofnEx.lStructSize = sizeof(m_ofnEx);

	int nResult;
	if (m_bOpenFileDialog)
		nResult = ::GetOpenFileName((OPENFILENAME*)&m_ofnEx);
	else
		nResult = ::GetSaveFileName((OPENFILENAME*)&m_ofnEx);

	memcpy(&m_ofn, &m_ofnEx, sizeof(m_ofn));
   m_ofn.lStructSize = sizeof(m_ofn);

	if (nResult)
		ASSERT(pThreadState->m_pAlternateWndInit == NULL);
	pThreadState->m_pAlternateWndInit = NULL;

	// WINBUG: Second part of special case for file open/save dialog.
	if (bEnableParent)
		::EnableWindow(m_ofnEx.hwndOwner, TRUE);
	if (::IsWindow(hWndFocus))
		::SetFocus(hWndFocus);

	PostModal();
    if (nResult == IDOK)
        FakeOnOK();
	return nResult ? nResult : IDCANCEL;
#endif
}

//////////////////
// When the open dialog sends a notification, copy m_ofnEx to m_ofn in
// case handler function is expecting updated information in the
// OPENFILENAME struct.
//
BOOL CFileDialogEx::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
#ifdef VC6
    memcpy(&m_ofn, &m_ofnEx, sizeof(m_ofn));
    m_ofn.lStructSize = sizeof(m_ofn);
#endif

   return CFileDialog::OnNotify( wParam, lParam, pResult);
}

void CFileDialogEx::OnTypeChange()
{
    updateCtrls();
}