// ContextFreeDoc.cpp : implementation of the CContextFreeDoc class
//

#include "stdafx.h"

#include "ContextFreeDoc.h"
#include "ContextFreeView.h"
#include "ChildFrm.h"
#include "WinSystem.h"
#include <Shlwapi.h>
#include <string>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CContextFreeDoc

IMPLEMENT_DYNCREATE(CContextFreeDoc, CDocument)

BEGIN_MESSAGE_MAP(CContextFreeDoc, CDocument)
	//{{AFX_MSG_MAP(CContextFreeDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
    ON_COMMAND(ID_FILE_SAVE, OnFileSave)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CContextFreeDoc construction/destruction

CContextFreeDoc::CContextFreeDoc()
:   mIsExample(false),
    mIncrementVariation(true),
    mEmpty(true)
{
	// TODO: add one-time construction code here

}

CContextFreeDoc::~CContextFreeDoc()
{
}

const CString& CContextFreeDoc::docName() const
{
    ASSERT(this);
    const CString& path = GetPathName();
    const CString& title = GetTitle();
    return path.IsEmpty() ? title : path; //.CompareNoCase(name) : !path.CompareNoCase(name);
}

void CContextFreeDoc::FixThePath(LPCTSTR name)
{
    // Undo the munging of the path to restore the example name as the path.
    // Happily this causes OnFileSave and OnFileSaveAs to do exactly the
    // right thing.
    m_strPathName = name;
    SetTitle(name);
}

BOOL CContextFreeDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

    mEmpty = true;      // remember that this is a new doc, so that we don't auto-render it

	return TRUE;
}

void CContextFreeDoc::OnFileSave()
{
    // Force Saves of examples to be SaveAs
    if (mIsExample) {
        CString prevPath = m_strPathName;
        CDocument::OnFileSaveAs();
        // But if the user actually saved then subsequent Saves are Saves
        if (prevPath != m_strPathName)
            mIsExample = false;
    } else {
        CDocument::OnFileSave();
    }
}

void CContextFreeDoc::OnFileRevert()
{
    ASSERT(m_strPathName && _tcslen(m_strPathName));

    if (mIsExample) 
        OnOpenExample(m_strPathName);
    else 
        CDocument::OnOpenDocument(m_strPathName);
}

bool CContextFreeDoc::isRevertable()
{
    return m_strPathName && _tcslen(m_strPathName) && IsModified();
}

BOOL CContextFreeDoc::OnOpenExample(LPCTSTR exName)
{
    int len;
    const char* cfdg = WinSystem::GetExample(exName, len);
    if (!cfdg)
        return FALSE;
    // suck the rules into a memory file and wrap this in a CArchive
    CMemFile mf((BYTE*)cfdg, len);
    CArchive ar(&mf, CArchive::load);
    Serialize(ar);              // tell doc to suck CArchive into doc
    SetModifiedFlag(FALSE);     // make clean
    //m_strPathName.Empty();      // no path name for embedded rules
    //SetTitle(exName);           // but we can have a title
    mIsExample = true;
    return TRUE;
}

BOOL CContextFreeDoc::OnOpenDocument(LPCTSTR pathName)
{
    mEmpty = false;
    // Check to see if this is a munged example name from CContextFreeApp::OnExample
    if (!_tcsncmp(pathName, theApp.m_pszHelpFilePath, _tcslen(theApp.m_pszHelpFilePath))) {
        pathName += _tcslen(theApp.m_pszHelpFilePath) + 1;
    }

    if (OnOpenExample(pathName))
        return TRUE;

	if (!CDocument::OnOpenDocument(pathName))
    {
		if (!OnNewDocument())
			return FALSE;
		SetPathName(pathName);
		return TRUE;
    }
    return TRUE;
}

void CContextFreeDoc::SetModifiedFlag(BOOL mod)
{
    // If anything happens to the document then tell the frame to not increment
    // the variation control on the next render.
    CDocument::SetModifiedFlag(mod);
    mEmpty = false;
    mIncrementVariation = false;
}

void CContextFreeDoc::DeleteContents()
{
    mEmpty = true;
    // Find the associated CEditView (CContextFreeView) and tell its CEdit
    // control to dump its contents.
	POSITION pos = GetFirstViewPosition();
	if (pos == NULL)
		return;

	// find the first view that is a CContextFreeView
	CContextFreeView* view = getView();
    if (view) {
        view->SetWindowText(NULL);
        view->Invalidate();
    }
}

std::string CContextFreeDoc::GetContents()
{
    CContextFreeView* pView = getView();
    ASSERT(pView);
    
    int len = pView->GetWindowTextLength();
    CString ttext;
    pView->GetWindowText(ttext);

#ifdef _UNICODE
    char* ctext = new char[len + 1];
    ::wcstombs(ctext, ttext, len + 1);
    std::string ret(ctext);
    delete[] ctext;
    return ret;
#else
    return std::string(ttext);
#endif
}


CContextFreeView* CContextFreeDoc::getView()
{
	POSITION pos = GetFirstViewPosition();
	if (pos == NULL)
		return 0;

	// find the first view that is a CContextFreeView
	CContextFreeView* view;
    while (pos != NULL)
    {
        view = (CContextFreeView*)GetNextView(pos);
        if (view->IsKindOf(RUNTIME_CLASS(CContextFreeView))) 
            return view;
    }
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CContextFreeDoc serialization

void CContextFreeDoc::Serialize(CArchive& ar)
{
	// find the first view that is a CContextFreeView and put the text into it.
    // We can't use CEditView::SerializeRaw because it can't handle Unix or
    // Mac line endings.
	CContextFreeView* view = getView();
    if (!view) return;

    if (ar.IsStoring()) {
        int len = view->GetWindowTextLength();
        LPTSTR text = new TCHAR[len + 1];
        char* ctext = 0;
        
        if (len && view->GetWindowText(text, len + 1)) {
#ifdef _UNICODE
            ctext = new char[len + 1];
            ::wcstombs(ctext, text, len + 1);
            delete[] text;
#else
            ctext = text;
#endif
            ar.Write((void*)ctext, len);
        }
        
        delete[] ctext;
        
    } else {
        ar.Flush();
        int len = (int)(ar.GetFile()->GetLength());
        char* oldText = new char[len + 1];
        ar.Read((void*)oldText, len);
        oldText[len] = '\0';
        
        LPTSTR newText = new TCHAR[2*len + 1];
        LPTSTR newTextAlso = newText;
        char* oldTextAlso = oldText;
        *newText = _T('\0');
        while (*oldText){
            if (*oldText == '\n') {
                *newText++ = _T('\r');
                *newText++ = _T('\n');
                oldText++;
                continue;
            }
            if (*oldText == '\r' &&  *(oldText+1) == '\n') {
                *newText++ = _T('\r');
                *newText++ = _T('\n');
                oldText += 2; 
                continue;
            }
            if (*oldText == '\r') {
                *newText++ = _T('\r');
                *newText++ = _T('\n');
                oldText++; 
                continue;
            }
            *newText++ = (TCHAR)(*oldText++);
        }
        *newText = _T('\0');
        CEdit& editor = view->GetEditCtrl();
        editor.SetWindowText(newTextAlso);
        delete[] newTextAlso;
        delete[] oldTextAlso;
        view->Invalidate();
    }
}

/////////////////////////////////////////////////////////////////////////////
// CContextFreeDoc diagnostics

#ifdef _DEBUG
void CContextFreeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CContextFreeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CContextFreeDoc commands
