// ContextFree.h : main header file for the CONTEXTFREE application
//

#if !defined(AFX_CONTEXTFREE_H__E137431F_447A_4AD2_8B64_2913B7192E09__INCLUDED_)
#define AFX_CONTEXTFREE_H__E137431F_447A_4AD2_8B64_2913B7192E09__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

#define WM_USER_SYNTAX_ERROR (WM_USER+0x105)

/////////////////////////////////////////////////////////////////////////////
// CContextFreeApp:
// See ContextFree.cpp for the implementation of this class
//
#include <list>
#include "RenderOptions.h"

class CFDG;
class WinCanvas;
class CMainFrame;
class WinSystem;
class CChildFrame;
class CContextFreeDoc;
class CRenderSize;
class CColorPickerDlg;

#include "FileDialogEx.h"

typedef std::list<CChildFrame*> CWinList;

class CContextFreeApp : public CWinApp
{
protected:
    bool mAfterStartup;
public:
    CRenderSize*    mRenderSize;
    CFileDialogEx*  mSaveDialog;
    CFileDialogEx*  mSaveMovieDialog;
    CColorPickerDlg* mColorPicker;
    CContextFreeApp();
    CRenderOptions* mOptions;
    LRESULT CFDGError(WPARAM path,LPARAM line);
    CContextFreeDoc* GetDocFromName(LPCTSTR name);
    CWinList mChildList; // list of open windows
    bool          mResizing;

// Profile getters/setters
    void setPrefProgressive(int pref) {WriteProfileInt(_T("Settings"), _T("ProgressiveRender"), pref);}
    int  getPrefProgressive() {return GetProfileInt(_T("Settings"), _T("ProgressiveRender"), TRUE);}

    void setPrefRenderOnOpen(int pref) {WriteProfileInt(_T("Settings"), _T("RenderOnOpen"), pref);}
    int  getPrefRenderOnOpen() {return GetProfileInt(_T("Settings"), _T("RenderOnOpen"), TRUE);}

    void setPrefStartup(int pref) {WriteProfileInt(_T("Settings"), _T("StartupDocument"), pref);}
    int  getPrefStartup() {return GetProfileInt(_T("Settings"), _T("StartupDocument"), CRenderOptions::Welcome);}

    void setPrefAppendVariation(int pref) {WriteProfileInt(_T("Settings"), _T("ImageAppendVariation"), pref);}
    int  getPrefAppendVariation() {return GetProfileInt(_T("Settings"), _T("ImageAppendVariation"), FALSE);}

    void setPrefCrop(int pref) {WriteProfileInt(_T("Settings"), _T("ImageCrop"), pref);}
    int  getPrefCrop() {return GetProfileInt(_T("Settings"), _T("ImageCrop"), TRUE);}

    void setPrefMaxTab(int pref) {WriteProfileInt(_T("Settings"), _T("MaximizeTabPane"), pref);}
    int  getPrefMaxTab() {return GetProfileInt(_T("Settings"), _T("MaximizeTabPane"), TRUE);}

    void setPrefBorderWidth(int pref) {WriteProfileInt(_T("Settings"), _T("BorderWidth"), pref);}
    int  getPrefBorderWidth() {return GetProfileInt(_T("Settings"), _T("BorderWidth"), 100);}

    void setPrefEmbedCFDG(int pref) {WriteProfileInt(_T("Settings"), _T("EmbedCFDG"), pref);}
    int  getPrefEmbedCFDG() {return GetProfileInt(_T("Settings"), _T("EmbedCFDG"), FALSE);}

    void setPrefJPEGqual(int pref) {WriteProfileInt(_T("Settings"), _T("JPEGQuality"), pref);}
    int  getPrefJPEGqual() {return GetProfileInt(_T("Settings"), _T("JPEGQuality"), 90);}

    void setPrefHeight(int pref) {WriteProfileInt(_T("Settings"), _T("RenderHeight"), pref);}
    int  getPrefHeight() {return GetProfileInt(_T("Settings"), _T("RenderHeight"), 1000);}

    void setPrefWidth(int pref) {WriteProfileInt(_T("Settings"), _T("RenderWidth"), pref);}
    int  getPrefWidth() {return GetProfileInt(_T("Settings"), _T("RenderWidth"), 1000);}

    void setPrefNoDisplay(int pref) {WriteProfileInt(_T("Settings"), _T("DontDisplay"), pref);}
    int  getPrefNoDisplay() {return GetProfileInt(_T("Settings"), _T("DontDisplay"), FALSE);}

    LPTSTR eptr;
    void   setPrefMinSize(LPCTSTR pref) {WriteProfileString(_T("Settings"), _T("MinimumSize"), pref);}
    double getPrefMinSize() {return _tcstod(GetProfileString(_T("Settings"), _T("MinimumSize"), _T("0.3")), &eptr);}

    void setPrefZoom(int pref) {WriteProfileInt(_T("Settings"), _T("AnimZoom"), pref);}
    int  getPrefZoom() {return GetProfileInt(_T("Settings"), _T("AnimZoom"), TRUE);}

    void setPrefLength(int pref) {WriteProfileInt(_T("Settings"), _T("AnimLength"), pref);}
    int  getPrefLength() {return GetProfileInt(_T("Settings"), _T("AnimLength"), 10);}

    void setPrefLengthUnits(int pref) {WriteProfileInt(_T("Settings"), _T("AnimUnits"), pref);}
    int  getPrefLengthUnits() {return GetProfileInt(_T("Settings"), _T("AnimUnits"), CFileDialogEx::Seconds);}

    void   setPrefUsername(LPCTSTR pref) {WriteProfileString(_T("Settings"), _T("GalUsername"), pref);}
    CString getPrefUsername() {return GetProfileString(_T("Settings"), _T("GalUsername"), _T(""));}

    void   setPrefPassword(LPCTSTR pref) {WriteProfileString(_T("Settings"), _T("GalPassword"), pref);}
    CString getPrefPassword() {return GetProfileString(_T("Settings"), _T("GalPassword"), _T(""));}

    void setPrefSkipAcct(int pref) {WriteProfileInt(_T("Settings"), _T("SkipAccount"), pref);}
    int  getPrefSkipAcct() {return GetProfileInt(_T("Settings"), _T("SkipAccount"), FALSE);}

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CContextFreeApp)
	public:
	virtual BOOL InitInstance();
    virtual int ExitInstance();
	//}}AFX_VIRTUAL
    //virtual BOOL OnDDECommand(LPTSTR command);

    afx_msg void OnFileRevert();
    afx_msg void OnFileRevertUI(CCmdUI* cmdUI);

// Implementation
	//{{AFX_MSG(CContextFreeApp)
	afx_msg void OnOptions();
	afx_msg void OnColorPicker();
	afx_msg void OnRender();
	afx_msg void OnRenderRepeat();
	afx_msg void OnRenderSize();
	afx_msg void OnSaveImage();
	afx_msg void OnSaveMovie();
	afx_msg void OnUpload();
	afx_msg void OnStop();
	afx_msg void OnExample(UINT nID);
	afx_msg void OnURL(UINT nID);
	afx_msg void OnAppAbout();
    afx_msg void OnFileNew();
    afx_msg void OnSetFont();

		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CONTEXTFREE_H__E137431F_447A_4AD2_8B64_2913B7192E09__INCLUDED_)
