// ContextFree.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "ContextFree.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "ContextFreeDoc.h"
#include "ContextFreeView.h"
#include "WinSystem.h"
#include "WinCanvas.h"
#include "CRenderView.h"
#include "RenderOptions.h"
#include "RenderSize.h"
#include <afxadv.h>
#include <atlbase.h>
#include "ColorPickerDlg.h"
#include "qtCanvas.h"
#include "XFontDialog.h"

#include <gdiplus.h>

using namespace Gdiplus;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

UINT RenderThreadProc(LPVOID);

/////////////////////////////////////////////////////////////////////////////
// CContextFreeApp

BEGIN_MESSAGE_MAP(CContextFreeApp, CWinApp)
	//{{AFX_MSG_MAP(CContextFreeApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	ON_COMMAND(ID_FILE_REVERT, OnFileRevert)
    ON_COMMAND(ID_EDIT_SETFONT, OnSetFont)
    ON_UPDATE_COMMAND_UI(ID_FILE_REVERT, OnFileRevertUI)
	ON_COMMAND(ID_RENDER_RENDER, CContextFreeApp::OnRender)
	ON_COMMAND(ID_RENDER_REPEAT, CContextFreeApp::OnRenderRepeat)
	ON_COMMAND(ID_RENDER_RENDERTOSIZE, CContextFreeApp::OnRenderSize)
	ON_COMMAND(ID_RENDER_STOP, CContextFreeApp::OnStop)
	ON_COMMAND(ID_RENDER_SAVEIMAGE, CContextFreeApp::OnSaveImage)
	ON_COMMAND(ID_RENDER_SAVEMOVIE, CContextFreeApp::OnSaveMovie)
	ON_COMMAND(ID_RENDER_PREFS, CContextFreeApp::OnOptions)
	ON_COMMAND(ID_COLORPICKER, CContextFreeApp::OnColorPicker)
	ON_COMMAND_RANGE(IDS_EX_CILIASUN, IDS_EX_I_POLYS, CContextFreeApp::OnExample)
	ON_COMMAND_RANGE(IDS_URL_CFDG, IDS_URL_GALLERY, CContextFreeApp::OnURL)
    ON_COMMAND(ID_RENDER_UPLOADTOGALLERY, CContextFreeApp::OnUpload)
	// Standard print setup command
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CContextFreeApp construction

CContextFreeApp::CContextFreeApp()
{
    mAfterStartup = false;
    mOptions = 0;
    mRenderSize = 0;
    mSaveDialog = 0;
    mResizing = false;
    mColorPicker = 0;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CContextFreeApp object

CContextFreeApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CContextFreeApp initialization

BOOL CContextFreeApp::InitInstance()
{
    // Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

    InitCommonControls();    // initialize common control library
    CWinApp::InitInstance(); // call parent class method	
    
#ifdef UNICODE
    //ASSERT(FALSE);
#endif
#ifdef MBCS
    ASSERT(FALSE);
#endif


	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// The registry key under which our settings are stored.
	SetRegistryKey(_T("OzoneSoft"));

	LoadStdProfileSettings(8);  // Load standard INI file options (including MRU)
    mOptions = new CRenderOptions(m_pMainWnd); // Load Context Free preferences

    CString name = GetProfileString(_T("Settings"), _T("EditTypeface"), _T("Courier"));
    int size = GetProfileInt(_T("Settings"), _T("EditTypesize"), -14);
    CContextFreeView::InitFont(name, size);

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_CFDGTYPE,
		RUNTIME_CLASS(CContextFreeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CContextFreeView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	// Enable DDE Execute open
    // The /nodde switch only happens when it is run in the development environment
    if (__argc != 2 || _tcscmp(__targv[1], _T("/nodde"))) {
    	EnableShellOpen();
	    RegisterShellFileTypes(TRUE);  
    }

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

    // Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;
    mAfterStartup = true;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();
    
    mRenderSize = new CRenderSize(m_pMainWnd);

    mSaveDialog = new CFileDialogEx(false, FALSE, _T("png"), NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
        _T("PNG file (*.png)|*.png|SVG file (*.svg)|*.svg|JPEG file (*.jpg or *.jpeg)|*.jpg;*.jpeg||"), theApp.m_pMainWnd);
    mSaveMovieDialog = new CFileDialogEx(true, FALSE, _T("mov"), NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
        _T("QuickTime file (*.mov)|*.mov||"), theApp.m_pMainWnd);

	return TRUE;
}

int CContextFreeApp::ExitInstance()
{
    if (mColorPicker) {
        mColorPicker->DestroyWindow();
        delete mColorPicker;
    }

    delete mOptions;
    delete mRenderSize;
    delete mSaveDialog;
    delete mSaveMovieDialog;

    WinCanvas::Shutdown();
    qtCanvas::systemExit();

    WinSystem::GetExampleName(0);

    return CWinApp::ExitInstance();
}

void CContextFreeApp::OnOptions()
{
    mOptions->DoModal();
}

void CContextFreeApp::OnColorPicker()
{
    WinCanvas::StartUp();
    if (!mColorPicker) {
        mColorPicker = new CColorPickerDlg(m_pMainWnd);
        mColorPicker->Create(IDD_DIALOG_COLORS, NULL);
    }
    mColorPicker->ShowWindow(SW_SHOWNORMAL);
}

void CContextFreeApp::OnRender()
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));
    
    child->OnRender();
}

void CContextFreeApp::OnRenderRepeat()
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));
    
    child->OnRenderRepeat();
}

void CContextFreeApp::OnRenderSize()
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));
    
    child->OnRenderSize();
}

void CContextFreeApp::OnStop()
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));

    child->StopNow();
}

void CContextFreeApp::OnSaveImage()
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));
    
    child->OnSaveImage();
}

void CContextFreeApp::OnSaveMovie()
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));
    
    child->OnSaveMovie();
}

void CContextFreeApp::OnUpload()
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));
    
    child->OnUpload();
}

void CContextFreeApp::OnFileNew()
{
    // If this is the OnFileNew at startup then implement the user's preference
    // about startup behavior
    if (mAfterStartup)
        CWinApp::OnFileNew();
    else {
        switch (this->getPrefStartup()) {
        case CRenderOptions::Welcome:
            OnExample(IDS_EX_WELCOME);
            break;
        case CRenderOptions::None:
            break;
        case CRenderOptions::Untitled:
        default:
            CWinApp::OnFileNew();
            break;
        }
    }
}

void CContextFreeApp::OnFileRevert()
{
    if (m_pMainWnd->MessageBox(_T("Lose all changes?"), _T("File Revert"), MB_YESNO|MB_ICONQUESTION) == IDYES) {
        CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
        ASSERT(child);
        ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));
    
        child->mDoc->OnFileRevert();
    }
}

void CContextFreeApp::OnFileRevertUI(CCmdUI* cmdUI)
{
    CChildFrame* child = (CChildFrame*)((CMainFrame*)m_pMainWnd)->MDIGetActive();
    ASSERT(child);
    ASSERT(child->IsKindOf(RUNTIME_CLASS(CChildFrame)));

    cmdUI->Enable(child->mDoc->isRevertable());
}

void CContextFreeApp::OnExample(UINT nID)
{
    // load the corresponding rules file from the embedded resources
    ASSERT(nID >= IDS_EX_CILIASUN && nID <= IDS_EX_I_POLYS);

    // Munge the example name so that the MFC framework doesn't turn it into
    // a full path name. CContextFreeDoc::OnFileOpen will unmunge it. We just
    // a full path that is easy to recognize as fake and guaranteed to not 
    // correspond to an actual cfdg file.
    TCHAR fakePath[MAX_PATH + 1];
    _tcscpy(fakePath, m_pszHelpFilePath);
    _tcscat(fakePath, _T("\\"));
    LPCTSTR ex = WinSystem::GetExampleName(nID);
    _tcscat(fakePath, ex);

    // Check if this example is already open and if so then give it a unique
    // title and path
    TCHAR fixedPath[MAX_PATH + 1];
    int i = 0;
    _tcscpy(fixedPath, WinSystem::GetExampleName(nID));
    while (GetDocFromName(fixedPath)) {
        _tcscpy(fixedPath, WinSystem::GetExampleName(nID));
        ::PathRemoveExtension(fixedPath);
        TCHAR ibuf[32];
        i++; wsprintf(ibuf, _T("[%d].cfdg"), i);
        _tcscat(fixedPath, ibuf);
    }

    // Open the example using the munged path, but temporarily clear the recent
    // file list pointer so that the munged path won't be added to the MRU file
    // list. We didn't want the example added anyway.
    CRecentFileList* list = m_pRecentFileList;
    m_pRecentFileList = 0;
    CContextFreeDoc* doc = (CContextFreeDoc*)OpenDocumentFile(fakePath);
    m_pRecentFileList = list;

    // Unmunge the path. CContextFreeDoc::OpenDocumentFile can't do it 
    // because MFC will remunge it while returning back to here. Plus,
    // we might change the path to make it unique.
    doc->FixThePath(fixedPath); 
}

CContextFreeDoc* CContextFreeApp::GetDocFromName(LPCTSTR name)
{
    for (CWinList::iterator it = mChildList.begin(); it != mChildList.end(); it++) {
        CChildFrame* child = *it;
		ASSERT(child->mDoc);
        if (!child->mDoc->docName().CompareNoCase(name))
            return child->mDoc;
    }
    return NULL;
}

void CContextFreeApp::OnURL(UINT nID)
{
    // open the corresponding URL in the user's browser of choice
    ASSERT(nID >= IDS_URL_CFDG && nID <= IDS_URL_GALLERY);
    TCHAR buf[100];
    LoadString(GetModuleHandle(NULL), nID, buf, 100);
    ShellExecute(NULL, _T("open"), buf, NULL, NULL, SW_SHOWNORMAL);
}


LRESULT CContextFreeApp::CFDGError(WPARAM path, LPARAM line)
{
    // Find out if the file with this error is open and if so then highlight
    // the error
    LPTSTR p = (LPTSTR)path;
    CContextFreeDoc* doc = GetDocFromName(p);
    delete[] p;

    if (!doc) return 0;
    ASSERT(doc->IsKindOf(RUNTIME_CLASS(CContextFreeDoc)));

	// find the first view that is a CContextFreeView
	CContextFreeView* view = doc->getView();
    if (view)
        view->HighlightLine(line);

    return 0;
}

void CContextFreeApp::OnSetFont()
{
    CXFontDialog cf;

    //cf.m_cf.Flags &= ~CF_EFFECTS;
    cf.m_cf.Flags |= CF_NOSCRIPTSEL | CF_FORCEFONTEXIST | CF_INITTOLOGFONTSTRUCT;
    cf.m_cf.lpLogFont = &CContextFreeView::Logfont;

    if (cf.DoModal() != IDOK) {
        //DWORD err = CommDlgExtendedError();
        return;
    }

    CContextFreeView::Font.DeleteObject();
    CContextFreeView::Font.CreateFontIndirect(&CContextFreeView::Logfont);
    WriteProfileString(_T("Settings"), _T("EditTypeface"), CContextFreeView::Logfont.lfFaceName);
    WriteProfileInt(_T("Settings"), _T("EditTypesize"), CContextFreeView::Logfont.lfHeight);

    for (CWinList::iterator it = mChildList.begin(); it != mChildList.end(); it++) {
        CChildFrame* child = *it;
		ASSERT(child->mDoc);
        CContextFreeView* view = child->mDoc->getView();
        if (view)
            view->SetFont(&CContextFreeView::Font, TRUE);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();
    ~CAboutDlg();
	virtual BOOL OnInitDialog();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    afx_msg void OnPaint();
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

CAboutDlg::~CAboutDlg()
{
}

BOOL CAboutDlg::OnInitDialog()
{
    BOOL res = CDialog::OnInitDialog();
    WinCanvas::StartUp();
    return res;
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
    ON_WM_PAINT()
END_MESSAGE_MAP()

// App command to run the dialog
void CContextFreeApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

void CAboutDlg::OnPaint()
{
    // About dialogs are never iconic
    if (GetUpdateRect(NULL, FALSE)) {
        CPaintDC dc(this); // device context for painting

        Graphics g(dc.m_hDC);
        g.DrawImage(WinCanvas::AppBitmap, 10, 35, 128, 128);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CContextFreeApp message handlers

