#pragma once
#include <gdiplus.h>

#define C_CCOLORWELL_CLASSNAME _T("MFCColorWell")

// CColorWell

class CColorWell : public CButton
{
	DECLARE_DYNAMIC(CColorWell)

public:
	CColorWell();
	virtual ~CColorWell();
    void SetColor(const Gdiplus::Color& c);
    void SetSelected(bool sel);

protected:
    bool mInitialized;
    bool mSel;
    Gdiplus::Color mColor;
    static Gdiplus::Bitmap* ButtonUp;
    static Gdiplus::Bitmap* ButtonDown;
    Gdiplus::Bitmap* mClient;
    Gdiplus::SolidBrush* mBackBrush;
    Gdiplus::Rect mFocusRect;
    Gdiplus::Rect mButtonRect;
    Gdiplus::Pen* mFocusPen;
    Gdiplus::Pen* mNoFocusPen;
    BOOL RegisterWindowClass();
    void Init();
    void UpdateClientBitmap();
    void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

	DECLARE_MESSAGE_MAP()
};


