// ColorWell.cpp : implementation file
//

#include "stdafx.h"
#include "ColorWell.h"
#include "CGdiPlusBitmap.h"
#include "resource.h"

using namespace Gdiplus;


// CColorWell

Bitmap* CColorWell::ButtonUp = 0;
Bitmap* CColorWell::ButtonDown = 0;

IMPLEMENT_DYNAMIC(CColorWell, CButton)

CColorWell::CColorWell() 
:   mInitialized(false),
    mSel(false),
    mColor(),
    mClient(0),
    mBackBrush(0),
    mFocusPen(0)
{
}

CColorWell::~CColorWell()
{
    delete mClient;
    delete mBackBrush;
    delete mFocusPen;
    delete mNoFocusPen;
}


BEGIN_MESSAGE_MAP(CColorWell, CButton)
END_MESSAGE_MAP()

void CColorWell::SetColor(const Color& c)
{
    if (mColor.ToCOLORREF() == c.ToCOLORREF()) return;

	mColor = c;
    UpdateClientBitmap();
	Invalidate(FALSE);
}

void CColorWell::SetSelected(bool sel)
{
    if ((sel && !mSel) || (!sel && mSel)) {
        mSel = sel;
        UpdateClientBitmap();
        Invalidate(FALSE);
    }
}

// CColorWell message handlers

void CColorWell::Init()
{
    CRect r;
    GetClientRect(&r);

    mClient = new Bitmap(r.Width(), r.Height(), PixelFormat24bppRGB);

    DWORD backcolor = ::GetSysColor(COLOR_3DFACE);
    Color back((BYTE)(backcolor & 255), 
        (BYTE)((backcolor >> 8) & 255), 
        (BYTE)((backcolor >> 16) & 255));
    mBackBrush = new SolidBrush(back);

    mFocusPen = new Pen(Color());
    mFocusPen->SetDashStyle(DashStyleDot);
    mNoFocusPen = new Pen(back);

    if (!ButtonUp) {
        CGdiPlusBitmapResource bm((LPCTSTR)IDB_UP);
        ButtonUp = bm.m_pBitmap;
        bm.m_pBitmap = 0;
    }
    if (!ButtonDown) {
        CGdiPlusBitmapResource bm((LPCTSTR)IDB_DOWN);
        ButtonDown = bm.m_pBitmap;
        bm.m_pBitmap = 0;
    }

    int h = ButtonUp->GetHeight();
    int w = ButtonUp->GetWidth();
    mButtonRect = Rect(r.left + (r.Width() - w) / 2, 
                       r.top + (r.Height() - h) / 2, w, h);
    mFocusRect = mButtonRect;
    mFocusRect.Inflate(3, 3);
    mFocusRect.Width--;
    mFocusRect.Height--;

    mInitialized = true;

    UpdateClientBitmap();
}

void CColorWell::UpdateClientBitmap()
{
    if (!mInitialized) return;
    Graphics g(mClient);
    g.FillRectangle(mBackBrush, 0, 0, mClient->GetWidth(), mClient->GetHeight());
    SolidBrush b(mColor);
    g.FillRectangle(&b, mButtonRect);
    g.DrawImage(mSel ? ButtonDown : ButtonUp, mButtonRect);
}

void CColorWell::DrawItem(LPDRAWITEMSTRUCT dis)
{
    ASSERT(dis->CtlType == ODT_BUTTON);

    if (!mInitialized) Init();

    Graphics g(dis->hDC);
    if (dis->itemAction & (ODA_DRAWENTIRE | ODA_SELECT))
        g.DrawImage(mClient, 0, 0, mClient->GetWidth(), mClient->GetHeight());
    if (dis->itemAction & (ODA_DRAWENTIRE | ODA_FOCUS)) {
        bool hasFocus = GetFocus() == this;
        g.DrawRectangle(hasFocus ? mFocusPen : mNoFocusPen, mFocusRect);
    }
}


