#pragma once
#include "HSBColor.h"
#include <gdiplus.h>
#include <agg_color_rgba.h>

#define C_CCOLORSLIDERCTRL_CLASSNAME _T("MFCColorSliderCtrl")

// CColorSliderCtrl

class CColorSliderCtrl : public CWnd
{
	DECLARE_DYNAMIC(CColorSliderCtrl)

public:
	CColorSliderCtrl();
	virtual ~CColorSliderCtrl();
    bool SetPos(int pos);
    int GetPos() const;
    void SetRange(int min, int max);
    void SetColor(const Gdiplus::Color& top, const Gdiplus::Color& bottom);
    enum {SLIDER_CHANGE = 4567};

protected:
    bool mInitialized;
    int mMin, mMax, mPos;
    int mHeight, mMinY;
    Gdiplus::Rect mFocusRect;
    Gdiplus::Rect mChannelRect;
    Gdiplus::Rect mCurrentRect;
    Gdiplus::Rect mLeftRect, mRightRect;
    Gdiplus::Pen* mFocusPen;
    Gdiplus::Pen* mNoFocusPen;
    Gdiplus::Bitmap* mChannelBitmap;
    static Gdiplus::Bitmap* MarkerBitmap;
    Gdiplus::Color mTopColor;
    Gdiplus::Color mBottomColor;
    Gdiplus::SolidBrush* mBackground;
    NMHDR mNotify;
    void CalcRect();
    void Init();
    void TrackPoint(CPoint p);
    void RedrawPoint();
    BOOL RegisterWindowClass();
    void RedrawChannel();
    void DrawFocus(Gdiplus::Pen* p);
    afx_msg void OnPaint();
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnSetFocus(CWnd*);
    afx_msg void OnKillFocus(CWnd*);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg UINT OnGetDlgCode();

	DECLARE_MESSAGE_MAP()
};


