// ColorPickerDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CColorPickerDlg dialog
#include "HSBColor.h"
#include <gdiplus.h>
#include <agg_color_rgba.h>
#include "resource.h"
#include "HueSatCtrl.h"
#include "ColorSliderCtrl.h"
#include "ColorDropperCtrl.h"
#include "ColorWell.h"

class CColorPickerDlg : public CDialog
{
// Construction
public:
	CColorPickerDlg(CWnd* pParent = NULL);   // standard constructor
	~CColorPickerDlg();
    COLORREF GetColor();

// Dialog Data
	//{{AFX_DATA(CColorPickerDlg)
	enum { IDD = IDD_DIALOG_COLORS };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CColorPickerDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
    enum UpdateExcludes {exc_huesat = 1, exc_bright = 2, exc_rgb_slider = 4,
        exc_rgb_edit = 8, exc_hsb_edit = 16};
	// Generated message map functions
	//{{AFX_MSG(CColorPickerDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnChangeEditFinish();
	afx_msg void OnChangeEditStart();
	afx_msg void OnChangeEditDelta();
	afx_msg void OnRGBEditChange();
	afx_msg void OnRGBChange(NMHDR* pNotifyStruct, LRESULT* result);
    afx_msg void OnSelectStart();
    afx_msg void OnSelectFinish();
    afx_msg void OnHSBChange(NMHDR* pNotifyStruct, LRESULT* result);
    afx_msg void OnDropper(NMHDR* pNotifyStruct, LRESULT* result);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    void UpdateRGB(int r, int g, int b);
		

	void SetEditVals();
	void SetEditVals(HSBColor& hsb, UINT HSBctrl);
    bool mSettingEditValue;
	void SetDeltaHSB();
	void SetFinishHSB();
    void changedHSBedit(UINT HSBctrl, HSBColor& hsb, 
        agg::rgba& c, bool isDelta = false);
    void DispatchColor(HSBColor& hsb, agg::rgba& rgb, int exclude);
    void UpdateRGB(int r, int g, int b, int exclude);

    CHueSatCtrl mHueSat;
    CColorSliderCtrl mBright;
    CColorSliderCtrl mRed;
    CColorSliderCtrl mGreen;
    CColorSliderCtrl mBlue;
    CColorDropperCtrl mDropper;
    CColorWell mStartWell;
    CColorWell mFinishWell;

	HSBColor mFinishHSBcolor, mStartHSBcolor, mDeltaHSBcolor;
    HSBColor* mSelectedHSBcolor;

    agg::rgba mFinishColor, mStartColor;
    agg::rgba* mSelectedRGBAcolor;

    enum SelectedColor { FinishSelected = 0, StartSelected = 1 };
    SelectedColor mSelectedColor;

	bool mInitOver;

    static ULONG_PTR GdiPToken;
    static Gdiplus::GdiplusStartupInput GdiPStartInput;
    static Gdiplus::GdiplusStartupOutput GdiPStartOutput;

};
