// ColorDropperCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ColorDropperCtrl.h"
#include "CGdiPlusBitmap.h"
#include "resource.h"

using namespace Gdiplus;


// CColorDropperCtrl

Bitmap* CColorDropperCtrl::DropperBitmap = 0;

IMPLEMENT_DYNAMIC(CColorDropperCtrl, CWnd)

BOOL CColorDropperCtrl::RegisterWindowClass()
{
    WNDCLASS  wndcls;
    HINSTANCE hInst = AfxGetInstanceHandle();

    // Already registered?
    if(!(::GetClassInfo(hInst, C_CCOLORDROPPERCTRL_CLASSNAME, &wndcls))) { 
        wndcls.style            = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
        wndcls.lpfnWndProc      = ::DefWindowProc;
        wndcls.cbClsExtra       = wndcls.cbWndExtra = 0;
        wndcls.hInstance        = hInst;
        wndcls.hIcon            = NULL;
        wndcls.hCursor          = AfxGetApp()->LoadCursor(IDC_ARROW);
        wndcls.hbrBackground    = (HBRUSH) (COLOR_3DFACE + 1);
        wndcls.lpszMenuName     = NULL;
        wndcls.lpszClassName    = C_CCOLORDROPPERCTRL_CLASSNAME;

        if(!AfxRegisterClass(&wndcls)) {
            AfxThrowResourceException();
            return FALSE;
        }
    }

    return TRUE;
}

CColorDropperCtrl::CColorDropperCtrl() 
:   mInitialized(false)
{
    RegisterWindowClass();
}

CColorDropperCtrl::~CColorDropperCtrl()
{
}


BEGIN_MESSAGE_MAP(CColorDropperCtrl, CWnd)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_PAINT()
END_MESSAGE_MAP()

void CColorDropperCtrl::GetColor(Color& c) const
{
	c = mColor;
}

// CColorDropperCtrl message handlers

void CColorDropperCtrl::Init()
{
    CRect r;
    GetClientRect(&r);

    mDropperRect = Rect(r.left + (r.Width() - 16) / 2, 
        r.top + (r.Height() - 16) / 2, 16, 16);
    
    if (!DropperBitmap) {
        CGdiPlusBitmapResource bm((LPCTSTR)IDB_DROPPER);
        DropperBitmap = bm.m_pBitmap;
        bm.m_pBitmap = 0;
    }

    mDropperCursor = AfxGetApp()->LoadCursor(IDC_DROPPER);

    mNotify.code = DROPPER_CHANGE;    
    mNotify.hwndFrom = GetSafeHwnd();
    mNotify.idFrom = GetDlgCtrlID();
    mInitialized = true;
}

void CColorDropperCtrl::OnPaint()
{
    if (GetUpdateRect(NULL, TRUE)) {
        if (!mInitialized) Init();
        CPaintDC dc(this);
        Graphics g(dc);
        g.DrawImage(DropperBitmap, mDropperRect);
    }
}

void CColorDropperCtrl::OnLButtonDown(UINT nFlags, CPoint point)
{
	SetCapture();
    mPrevCursor = ::SetCursor(mDropperCursor);
	TrackPoint();

	CWnd::OnLButtonDown(nFlags, point);
}

void CColorDropperCtrl::OnLButtonUp(UINT nFlags, CPoint point)
{
	if (GetCapture() == this) {
		ReleaseCapture();
        ::SetCursor(mPrevCursor);
    }
	CWnd::OnLButtonUp(nFlags, point);
}

void CColorDropperCtrl::OnMouseMove(UINT nFlags, CPoint point)
{
	if (GetCapture() == this) {
		TrackPoint();
	}
	CWnd::OnMouseMove(nFlags, point);
}

void CColorDropperCtrl::TrackPoint()
{
    POINT pt;
    GetCursorPos(&pt);
    CClientDC desktop(NULL);
    Color c;
    c.SetFromCOLORREF(desktop.GetPixel(pt));

    if (c.ToCOLORREF() != mColor.ToCOLORREF()) {
        mColor = c;
        GetParent()->SendNotifyMessage(WM_NOTIFY, mNotify.idFrom, (LPARAM)(&mNotify));
    }
}

