// ChildFrm.h : interface of the CChildFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHILDFRM_H__3A2654B8_2359_41CA_82D5_F5EAE9F117CD__INCLUDED_)
#define AFX_CHILDFRM_H__3A2654B8_2359_41CA_82D5_F5EAE9F117CD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ChildFrm.h"
#include "ContextFree.h"
#include "ContextFreeView.h"
#include "CRenderView.h"
#include "RenderOptions.h"

extern CContextFreeApp theApp;

#include <afxmt.h>
#include "WinCanvas.h"
#include "WinSystem.h"
#include "CFDGCtrlBar.h"
#include "GdiPlus.h"
#include "agg_trans_affine.h"
#include <string>

#define WM_USER_STATUS_UPDATE (WM_USER+0x102)
#define WM_USER_MESSAGE_UPDATE (WM_USER+0x103)
#define WM_USER_RENDER_OVER (WM_USER+0x104)
#define WM_USER_MAXIMIZE_ME (WM_USER+0x106)

class CRenderView;
class CContextFreeDoc;
class Renderer;
class CFileDialogEx;
class qtCanvas;
class SVGCanvas;
class tiledCanvas;

class CChildFrame : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CChildFrame)
public:
    enum RenderMode {New = 0, Idle = 1, Rendering=2, Stopping = 3};
	CChildFrame();

// Attributes
protected:
    CCFDGCtrlBar  mCtrlBar;
    CFDG*           mCFDG;
    Renderer*       mRenderer;
	CWinThread*		mRenderThread;
	CSplitterWnd mSplit;
    bool          mRenderAgain;
    bool          mRenderSizeAgain;
    bool          mRepeatRenderAgain;
    bool          mClose;
    aggCanvas::PixelFormat mPixfmt;
    static int    ChildCount;
    int           mWidth;
    int           mHeight;
    double        mScale;
    qtCanvas*     mAnimationCanvas;
    SVGCanvas*    mSVGCanvas;
    int           mAnimateFrameCount;
    char*         mDescription;
    bool          mPartialDraw;
    RenderMode    mRenderMode;
    bool          mLastRenderWasToSize;

public:
    bool          mDisablePartial;
	bool          mThreadRunning;
    bool          mUsesAlpha;
    bool          mTiled;
    CMutex	      mOwnCanvas;
	WinSystem  mSystem;
    WinCanvas*      mCanvas;
    tiledCanvas*    mTiledCanvas;
    agg::trans_affine mTile_tr;
    CRenderView*    mRenderView;
    CContextFreeDoc* mDoc;

// Operations
public:
    static int CChildFrame::GetEncoderClsid(const WCHAR* format, CLSID* pClsid);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChildFrame)
	public:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	//}}AFX_VIRTUAL
	afx_msg int OnCreate(LPCREATESTRUCT cs);
    afx_msg void OnDestroy();
    afx_msg void OnClose();
    afx_msg void OnSize(UINT type, int width, int height);

// Implementation
public:
	virtual ~CChildFrame();
    afx_msg void OnRender();
    afx_msg void OnRenderRepeat();
    afx_msg void OnRenderButton();
    afx_msg void OnRenderSize();
    afx_msg void OnStop();
    void          StopNow();
    afx_msg void OnSaveImage();
    afx_msg void OnSaveMovie();
    afx_msg void OnUpload();
    afx_msg void OnRandomSpin(int v);
    void Render();
    void UploadIt();
    void UpdateIcon(int);
    Gdiplus::Status SaveToPNGorJPEG(LPCTSTR name, bool jpeg, bool rect);
    Gdiplus::Status SaveToPNGorJPEG(IStream* pIStream, bool jpeg, bool rect);
private:
    void RunRenderThread();
    void RenderMe(int width = 0, int height = 0, bool nodisplay = false, 
        double minsize = 0.0);
    void SaveToSVG(LPCTSTR);
    Gdiplus::Status SaveToPNGorJPEG(IStream* pIStream, LPCTSTR name, bool jpeg, bool rect);
    afx_msg void OnRandomText();
    afx_msg void OnTimer( UINT nIDEvent );
    LRESULT OnStatusUpdate(WPARAM wParam,LPARAM lParam);
    LRESULT OnMessageUpdate(WPARAM wParam,LPARAM lParam);
    LRESULT CFDGError(WPARAM path,LPARAM line);
    LRESULT OnRenderOver(WPARAM ,LPARAM);
    LRESULT OnMax(WPARAM ,LPARAM);
    void          SetMode(RenderMode);  // this can only be called from the UI thread!!!!!
    void setupCanvas();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
protected:
    void          noteStats(bool showScaling, System::Stats* s);
    int           mProgressDelay;
    UINT          mTimerID;
    UINT          mBusyCount;
	int           mVariation;
    double        mMinSize;
    void          alert(LPCTSTR msg, bool beep = true) 
    {
        mCtrlBar.mMessage.SetWindowText(msg);
        if (beep) MessageBeep(MB_ICONASTERISK);
    }

// Generated message map functions
protected:
	//{{AFX_MSG(CChildFrame)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHILDFRM_H__3A2654B8_2359_41CA_82D5_F5EAE9F117CD__INCLUDED_)
