#include "posixSystem.h"

#include "stdarg.h"

#include <string>
#include <fstream>

using namespace std;


void
PosixSystem::message(const char* fmt, ...)
{
	char buf[256];
	{
		va_list args;
		va_start(args, fmt);
		vsnprintf(buf, sizeof(buf), fmt, args);
		buf[sizeof(buf)-1] = '\0';
		va_end(args);
	}
	
	cout << buf << "                            " << endl;
}

void
PosixSystem::syntaxError(const std::string&, int)
{
  // this version doesn't high-light the line in error
  // the parser will have already called message() with
  // the syntax error information
}

istream*
PosixSystem::openFileForRead(const string& path)
{
    if (path == "-") return &cin;
	return new ifstream(path.c_str(), ios::binary);
}

istream*
PosixSystem::tempFileForRead(const string& path)
{
	return new ifstream(path.c_str(), ios::binary);
}

ostream*
PosixSystem::tempFileForWrite(string& prefixInNameOut)
{
	string t = "/tmp/" + prefixInNameOut + "XXXXXX";
	char* b = new char[t.size() + 1];
	strcpy(b, t.c_str());
	
	ofstream* f = 0;
	
	if (mktemp(b)) {
		f = new ofstream;
		f->open(b, ios::binary);
		prefixInNameOut = b;
	}
	delete b;
	
	return f;
}
		
string
PosixSystem::relativeFilePath(const string& base, const string& rel)
{
	string s = base;
	
	int i = s.rfind('/');
	if (i == string::npos) {
		return rel;
	}
	i += 1;
	s.replace(i, s.length() - i, rel);	
	return s;
}

void
PosixSystem::stats(const Stats& s)
{
    cout << "    " << s.shapeCount << " shapes";

    if (s.toDoCount > 0)
        cout << " - " << s.toDoCount << " expansions to do";
    else
        cout << "                            ";

    cout << "        \r";
    cout.flush();
}


