//
//  TopBar.m
//  Context Free
//
//  Created by Mark Lentczner on 5/2/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "TopBar.h"
#include <math.h>

namespace {
    void
    moveView(NSView* superView, NSView* subView,
        const NSRect& oldSubFrame, const NSRect& newSubFrame)
    {
        if (NSEqualRects(oldSubFrame, newSubFrame)) return;
        
        [superView setNeedsDisplayInRect: oldSubFrame];
        [subView setFrame: newSubFrame];
        [subView setNeedsDisplay: YES];
    }
};

@implementation TopBar

- (void)awakeFromNib
{
    [self relayout];
}

- (void)relayout
{
    [self resizeSubviewsWithOldSize: [self frame].size];
}

- (void)resizeSubviewsWithOldSize:(NSSize)oldBoundsSize
{
    NSSize size = [self frame].size;
    
    NSRect midOld = [mCenterControls frame];
    NSRect midNew = midOld;
    midNew.origin.x = floor((size.width - midNew.size.width) / 2.0);
    moveView(self, mCenterControls, midOld, midNew);
    
    NSRect leftOld = [mLeftStatus frame];
    NSRect leftNew = leftOld;
    float xSpace = leftOld.origin.x;
    leftNew.size.width = midNew.origin.x - xSpace - leftNew.origin.x;
    moveView(self, mLeftStatus, leftOld, leftNew);
    
    float rightEdge = size.width;
    
    if (![mProgressOne isHidden]) {
        NSRect progOld = [mProgressOne frame];
        NSRect progNew = progOld;
        progNew.origin.x = rightEdge - xSpace - progNew.size.width;
        moveView(self, mProgressOne, progOld, progNew);
        rightEdge = progNew.origin.x;
    }
    if (![mProgressTwo isHidden]) {
        NSRect progOld = [mProgressTwo frame];
        NSRect progNew = progOld;
        progNew.origin.x = rightEdge - xSpace - progNew.size.width;
        moveView(self, mProgressTwo, progOld, progNew);
        rightEdge = progNew.origin.x;
    }
    
    NSRect rightOld = [mRightStatus frame];
    NSRect rightNew = rightOld;
    rightNew.origin.x = midNew.origin.x + midNew.size.width + xSpace;
    rightNew.size.width = rightEdge - xSpace - rightNew.origin.x;
    moveView(self, mRightStatus, rightOld, rightNew);
}

@end
