//
//  imagecanvas.mm
//  Context Free
//
//  Created by Mark Lentczner on 2006-02-22.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "imagecanvas.h"

#import <Cocoa/Cocoa.h>

#import "GView.h"


ImageCanvas::ImageCanvas(GView* view, NSBitmapImageRep* bitmap,
		PixelFormat format)
    : aggCanvas(format), mView(view)
{
    NSSize size = [bitmap size];
    int pixelWidth = (int)size.width;
    int pixelHeight = (int)size.height;
        
    attach([bitmap bitmapData], pixelWidth, pixelHeight,
        [bitmap bytesPerRow]);
}

ImageCanvas::~ImageCanvas()
    { }

void
ImageCanvas::start(bool clear,  const agg::rgba& background,
    int width, int height)
{
    aggCanvas::start(clear, background, width, height);
}

void
ImageCanvas::end()
{
    aggCanvas::end();

    [mView performSelectorOnMainThread: @selector(redisplayImage:)
        withObject: [NSValue valueWithRect:
            NSMakeRect(cropX(), cropY(), cropWidth(), cropHeight())]
        waitUntilDone: YES];
}
