//
//  GView.h
//  CFDA
//
//  Created by Mark Lentczner on 4/15/05.
//  Copyright 2005 Mark Lentczner. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CFDGDocument;
@class TopBar;

class CFDG;
class Canvas;
class Renderer;
class qtCanvas;
class tiledCanvas;

@interface GView : NSView {
    CFDG*       mEngine;
    Renderer*   mRenderer;
    Canvas*     mCanvas;
    
    NSImage*			mRenderedImage;
	NSBitmapImageRep*	mRenderedBitmap;
    NSRect				mRenderedRect;
	
    NSTimer*    mUpdateTimer;
    int         mOutputProgressDelay;
    
    bool mRendering;
    bool mRestartRenderer;
    bool mRendererFinishing;
    bool mRendererStopping;
    bool mLastRenderWasHires;
    
    NSSize mLastRenderSize;
    float mLastRenderMin;
    
    bool mCanvasColor256;

    IBOutlet CFDGDocument*          mDocument;

    IBOutlet TopBar*                mTopBar;
    IBOutlet NSButton*              mRenderControl;
    IBOutlet NSTextField*           mStatus;
    IBOutlet NSProgressIndicator*   mProgress;
    IBOutlet NSProgressIndicator*   mOutputProgress;
    
    int     mCurrentVariation;
    bool    mIncrementVariationOnRender;
    
    IBOutlet NSTextField*           mVariationLabel;
    IBOutlet NSTextField*           mVariationField;
    IBOutlet NSStepper*             mVariationStepper;
    
    IBOutlet NSView*                mSaveImageAccessory;
    IBOutlet NSView*                mSaveTileAccessory;
    IBOutlet NSMatrix*                  mSaveTileOptions;
	IBOutlet NSView*				mSaveAnimationAccessory;
	
	qtCanvas*	mAnimationCanvas;
	
	tiledCanvas*	mTiledCanvas;
    double  mScale;
}

- (id)initWithFrame:(NSRect)frame;

- (IBAction)toggleRender:(id)sender;
- (IBAction)saveImage:(id)sender;
- (IBAction)saveTileImage:(id)sender;
- (IBAction)saveAsSVG:(id)sender;
- (IBAction)saveAsMovie:(id)sender;
- (IBAction)showMovieSettings:(id)sender;

- (BOOL)validateMenuItem:(NSMenuItem *)anItem;

- (IBAction) showHiresRenderSheet:(id)sender;

- (void)noteStats:(NSValue*)v;

- (int) variation;
- (bool) canvasColor256;
- (bool) isTiled;
- (NSData*) pngImageDataCropped:(BOOL)cropped rectangular:(BOOL) rect;

@end

@interface GView (renderControl)
- (IBAction) startRender:(id)sender;
- (IBAction) finishRender:(id)sender;
- (IBAction) stopRender:(id)sender;
- (IBAction) repeatRender:(id)sender;
- (void) startHiresRender: (NSSize) size minimum: (float) minSize;
@end

@interface GView (variationControl)
- (void) initializeVariation;
- (void) updateVariation:(BOOL)incrementIfNeeded;
- (void) useVariation;
- (void) reuseVariation;
- (IBAction) adjustVariation:(id)sender;    // sent by stepper
- (IBAction) editVariation:(id)sender;      // sent by text field
@end
