//
//  ColorCalc.mm
//  Context Free
//
//  Created by Mark Lentczner on 2005-07-23.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "ColorCalc.h"
#include "HSBColor.h"

namespace {
    NSString* buildText(float hue, float saturation, float brightness)
    {
        return [NSString stringWithFormat: @"hue %.1f sat %.4f b %.4f",
            hue, saturation, brightness];
    }
    
};

@implementation ColorCalc

+ (void)initialize {
    NSArray* a;
    
    a = [NSArray arrayWithObject: @"startColor"];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"startHue"];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"startSaturation"];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"startBrightness"];
    
    a = [NSArray arrayWithObjects:
        @"startHue", @"startSaturation", @"startBrightness", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"startColor"];

    a = [NSArray arrayWithObjects:
        @"startHue", @"startSaturation", @"startBrightness",
        @"startColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"startText"];



    a = [NSArray arrayWithObjects:
        @"startHue", @"finishHue", 
        @"startColor", @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"deltaHue"];

    a = [NSArray arrayWithObjects:
        @"startSaturation", @"finishSaturation", 
        @"startColor", @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"deltaSaturation"];

    a = [NSArray arrayWithObjects:
        @"startBrightness", @"finishBrightness", 
        @"startColor", @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"deltaBrightness"];

    a = [NSArray arrayWithObjects:
        @"startHue", @"startSaturation", @"startBrightness",
        @"deltaHue", @"deltaSaturation", @"deltaBrightness",
        @"finishHue", @"finishSaturation", @"finishBrightness",
        @"startColor", @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"deltaText"];



    a = [NSArray arrayWithObjects: @"deltaHue", @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"finishHue"];

    a = [NSArray arrayWithObjects: @"deltaSaturation", @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"finishSaturation"];

    a = [NSArray arrayWithObjects: @"deltaBrightness", @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"finishBrightness"];

    a = [NSArray arrayWithObjects:
        @"deltaHue", @"deltaSaturation", @"deltaBrightness",
        @"finishHue", @"finishSaturation", @"finishBrightness",
        nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"finishColor"];

    a = [NSArray arrayWithObjects:
        @"deltaHue", @"deltaSaturation", @"deltaBrightness",
        @"finishHue", @"finishSaturation", @"finishBrightness",
        @"finishColor", nil];
    [self setKeys: a triggerChangeNotificationsForDependentKey: @"finishText"];
}



- (NSColor*) startColor
{
    return [NSColor colorWithCalibratedHue: startHue / 360.0
                saturation: startSaturation
                brightness: startBrightness
                alpha: 1.0];
}

- (NSColor*) finishColor;
{
    return [NSColor colorWithCalibratedHue: finishHue / 360.0
                saturation: finishSaturation
                brightness: finishBrightness
                alpha: 1.0];
}

- (void)  setStartColor: (NSColor*) c
{
    startHue = [c hueComponent] * 360.0;
    startSaturation = [c saturationComponent];
    startBrightness = [c brightnessComponent];
}

- (void)  setFinishColor: (NSColor*) c;
{
    finishHue = [c hueComponent] * 360.0;
    finishSaturation = [c saturationComponent];
    finishBrightness = [c brightnessComponent];
}

- (NSString*)   startText
    { return buildText(startHue, startSaturation, startBrightness); }

- (NSString*)   finishText;
    { return buildText(finishHue, finishSaturation, finishBrightness); }

- (float) deltaHue
    { return HSBColor::deltaHue(finishHue, startHue); }
    
- (void) setDeltaHue: (float) h
    { finishHue = HSBColor::adjustHue(startHue, h); }
    
- (float) deltaSaturation
    { return HSBColor::delta(finishSaturation, startSaturation); }

- (void) setDeltaSaturation: (float) s
    { finishSaturation = HSBColor::adjust(startSaturation, s); }
    
- (float) deltaBrightness
    { return HSBColor::delta(finishBrightness, startBrightness); }
    
- (void) setDeltaBrightness: (float) b
    { finishBrightness = HSBColor::adjust(startBrightness, b); }
    
- (NSString*) deltaText
{
    return buildText(
        [self deltaHue], [self deltaSaturation], [self deltaBrightness]);
}
        


@end
