/*
 *  yglue.h
 *  CFDA
 *
 *  Created by Mark Lentczner on 4/14/05.
 *  Copyright 2005 __MyCompanyName__. All rights reserved.
 *
 */

#ifdef __cplusplus
extern "C" {
#endif


typedef double yg_real;
typedef char * yg_string;

typedef union {
    yg_real     real;
    yg_string   string;
} yystype;

#define YYSTYPE yystype

#define YY_INPUT(buf,result,max_size) \
    { result = yg_Input(buf, max_size); if (result == 0) result = YY_NULL; }

yg_real     yg_BuildReal(const char*);
yg_string   yg_BuildString(const char*);
void        yg_FreeString(yg_string);

void yg_IncludeFile(yg_string);

void yg_Initialize(yg_string);
void yg_Background();
const char* yg_Tile();
const char* yg_SizeLine();
void yg_Rule(yg_string, yg_real weight);
void yg_Replacement(yg_string);
void yg_ReplacementLoop(yg_string, int);
void yg_DefTransform();
void yg_SaveTransform();
void yg_ClearTransform();

void yg_Orientation(yg_real);
void yg_Reflection(yg_real);
void yg_XLocation(yg_real);
void yg_YLocation(yg_real);
void yg_ZLocation(yg_real);
void yg_Size(yg_real, yg_real, yg_real);
void yg_Skew(yg_real, yg_real);
void yg_Hue(yg_real, int);
void yg_Saturation(yg_real, int);
void yg_Brightness(yg_real, int);
void yg_Alpha(yg_real, int);
void yg_HueTarget(yg_real, int);
void yg_SaturationTarget(yg_real, int);
void yg_BrightnessTarget(yg_real, int);
void yg_AlphaTarget(yg_real, int);

void yg_Reset();
void yg_ResetForNextFile();
int yg_Input(char*, int);

void yyerror(const char *);
int yylex(void);

#ifdef __cplusplus
}
#endif
