/*
 *  upload.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 1/5/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_UPLOAD_H
#define INCLUDE_UPLOAD_H

#include <iosfwd>
#include <string>

class Upload {
	public:
        Upload() : mVariation(0), mCompression(CompressJPEG), mTiled(false) {}
		enum Compression {
			CompressJPEG = 0,
			CompressPNG8 = 1
		};

		std::string		mUserName;
		std::string		mPassword;
		
		std::string		mTitle;
		std::string		mNotes;
		
		std::string		mFileName;	// include .cfdg ending here
		int				mVariation;
		Compression		mCompression;
        bool            mTiled;
		
		const char*		mText;		// cfdg file, utf-8 text
		size_t			mTextLen;
		
		const char*		mImage;		// png data
		size_t			mImageLen;
		
		void generatePayload(std::ostream&);
		
        static std::string generateHeader();
		static std::string generateContentType();
};

#endif // INCLUDE_UPLOAD_H
