/*
 *  upload.cpp
 *  Context Free
 *
 *  Created by Mark Lentczner on 1/5/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#include "upload.h"

#include <iostream>

#include "variation.h"


namespace {
	const char mime_boundary[] = "a3c8dfd7-dce4-443c-ae3c-446df50f28c0";
	const char mime_endl[] = "\r\n";
	
	void generateMimeBoundary(std::ostream& out)
	{
		out << mime_endl << "--" << mime_boundary << mime_endl;
	}
	
	void generateMimeFooter(std::ostream& out)
	{
		out << mime_endl << "--" << mime_boundary << "--" << mime_endl;
	}
	
	void generateTextField(std::ostream& out, const char* field,
		const std::string& value)
	{
		generateMimeBoundary(out);
		
		out << "Content-Disposition: form-data"
				<< "; name=" << field	// shouldn't need quotes
				<< mime_endl
			<< "Content-Type: text/plain; charset=UTF-8" << mime_endl
			<< mime_endl;
		
		out << value; 
	}
	
	void generateFileField(std::ostream& out, const char* field,
		const char* data, size_t length, const std::string& fileName)
	{
		generateMimeBoundary(out);
		
		out << "Content-Disposition: form-data"
				<< "; name=" << field	// shouldn't need quotes
				<< "; filename=\"" << fileName << '"'
				<< mime_endl
			<< "Content-Type: application/octet-stream" << mime_endl
			<< mime_endl;
			
        out.write(data, length);
	}
	
	std::string compressionName(Upload::Compression compression)
	{
		switch (compression) {
			default:
			case Upload::CompressJPEG:	return "JPEG";
			case Upload::CompressPNG8:	return "PNG-8";
		}
	}
	
	std::string variationName(int variation)
	{
		char buffer[Variation::maxStringLength];
		Variation::toString(variation, buffer, false);
		return buffer;
	}
}

std::string Upload::generateHeader()
{
    return std::string("Content-Type: multipart/form-data; boundary=") + 
        mime_boundary;
}

std::string Upload::generateContentType()
{
    return std::string("multipart/form-data; boundary=") + 
        mime_boundary;
}

void
Upload::generatePayload(std::ostream& out)
{
	generateTextField(out, "screenname", mUserName);
	generateTextField(out, "password", mPassword);
	
	generateTextField(out, "agent", "ContextFree");
	
	generateTextField(out, "title", mTitle);
	generateFileField(out, "cfdgfile", mText, mTextLen, mFileName);
	generateFileField(out, "imagefile", mImage, mImageLen, "image.png");
	generateTextField(out, "compression", compressionName(mCompression));
    if (mTiled)
    	generateTextField(out, "tiled", "on");
	generateTextField(out, "variation", variationName(mVariation));
	generateTextField(out, "notes", mNotes);

	// generateTextField(out, "submit", "Upload!");
	
	generateMimeFooter(out);
}
