/*
 *  Wheat -- http://www.wheatfarm.org/
 *      Copyright (c) 2003 Glyphic Technology
 *      Licensed under the Academic Free License version 2.0
 *
 */

// A small test framework

#ifndef INCLUDED_TEST_H
#define INCLUDED_TEST_H

#include <iosfwd>
#include <string>

namespace Test {
	class testlocation {
	public:
		testlocation(const char* f, long l, int = 0);
		testlocation(const char* f, long l, const testlocation& t);		
		testlocation(const testlocation& o);
		
		operator std::string() const;
		void put(std::ostream&) const;

	private:
		testlocation& operator=(const testlocation& o);

		const char*         file;
		int                 line;
		const testlocation* from;
	};


	class test {
	public:
		test(const char* group, const char* name,
			const char* built = __DATE__ " " __TIME__);
		virtual void run() = 0;
		std::string name;
	protected:
		static const int _called_from = 0;
	};
	


	void pass(const testlocation& loc);
	
	void fail(const testlocation& loc,
				const std::string& message);

	void failsame(const testlocation& loc,
				const char* expectExpr, const char* actualExpr);
	
	void skip(const testlocation& loc);
	
	
	void failsame(const testlocation& loc,
				 const char* expectExpr, const std::string& expected,
				 const char* actualExpr, const std::string& actual);

	void fail_contains(const testlocation& loc, 
				const std::string& needle, 
				const std::string& haystack);

	template <typename T>
	std::string tostring(T)						{ return ""; }
	std::string tostring(const std::string& s);
	std::string tostring(int i);
	std::string tostring(bool b);
	
	template <typename TE, typename TA>
	void check_same(const testlocation& loc,
				 const char* expectExpr, TE expected,
				 const char* actualExpr, TA actual)
	{        
		if (actual != (TA)expected)
			failsame(loc,
				expectExpr, tostring((TA)expected),
				actualExpr, tostring(actual));
		else
			pass(loc);
	}

	void check_contains(const testlocation& loc,
		const char* needleExpr, const std::string& needle,
		const char* haystackExpr, const std::string& haystack);
			
	void check(const testlocation& loc,
					const char* expr, bool actual);
	
	
	bool runAll(
		bool reportPerGroup = false,
		bool stopOnFailingGroup = false);
		// returns true if passes all tests
}


#define TEST(group, name) \
    struct Test_##group##_##name : public ::Test::test { \
        Test_##group##_##name() : ::Test::test(#group, #name) { } \
        void run(); \
    } test_##group##_##name; \
    void Test_##group##_##name::run()


#define HERE    ::Test::testlocation(__FILE__, __LINE__, _called_from)
#define WHERE   const ::Test::testlocation& _called_from
#define THERE   _called_from


#define PASS() \
    ::Test::pass(HERE)
    
#define FAIL(message) \
    ::Test::fail(HERE, message)

#define SKIP() \
    ::Test::skip(HERE)
    
#define CHECK(cond) \
    ::Test::check(HERE, #cond, cond)

#define CHECK_MSG(cond, message) \
    ::Test::check(HERE, message, cond)

#define CHECK_SAME(v, e) \
    ::Test::check_same(HERE, #v, v, #e, e)

#define CHECK_CONTAINS(needle, haystack) \
    ::Test::check_contains(HERE, #needle, needle, #haystack, haystack)

#define CHECK_VALID(ptr) \
    CHECK((ptr) != 0)


#endif // INCLUDED_TEST_H
