/*
 *  tempfile.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 2006-02-16.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_TEMPFILE_H
#define INCLUDE_TEMPFILE_H

#include "cfdg.h"
#include "countable.h"

class TempFile : protected Countable
{
public:
    static ref_ptr<TempFile>
        build(System*, const char* prefix, const char* type, int num);

    std::ostream* forWrite();
    std::istream* forRead();

    std::string type()   { return mType; }
    int         number() { return mNum; }
    
protected:
    TempFile(System*, const char* prefix, const char* type, int num);
    virtual ~TempFile();

private:
    friend class ref_ptr<TempFile>;
    
    System*     mSystem;
    std::string mPath;
    std::string mType;
    int         mNum;
    bool        mWritten;
};

#endif // INCLUDE_TEMPFILE_H
