#include "shape.h"
#include <stdlib.h>


FinishedShape::FinishedShape(const Shape& s, double cumulativeArea)
{
    mPrimitiveShapeType = (unsigned char)(s.mShapeType);

    m_MiniTransform[0] = (float)s.mWorldState.m_transform.sx;
    m_MiniTransform[1] = (float)s.mWorldState.m_transform.shy;
    m_MiniTransform[2] = (float)s.mWorldState.m_transform.shx;
    m_MiniTransform[3] = (float)s.mWorldState.m_transform.sy;
    m_MiniTransform[4] = (float)s.mWorldState.m_transform.tx;
    m_MiniTransform[5] = (float)s.mWorldState.m_transform.ty;

    agg::rgba c;
    s.mWorldState.m_Color.getRGBA(c);
    mColor = RGBA8(c);

    m_Z = (float)s.mWorldState.m_Z;
	
	mCumulativeArea = cumulativeArea;
}


void FinishedShape::GetTransform(agg::trans_affine& tr) const
{
    tr.sx  = (double)m_MiniTransform[0];
    tr.shy = (double)m_MiniTransform[1];
    tr.shx = (double)m_MiniTransform[2];
    tr.sy  = (double)m_MiniTransform[3];
    tr.tx  = (double)m_MiniTransform[4];
    tr.ty  = (double)m_MiniTransform[5];
}


//-------------------------------------------------------------------------////
//-------------------------------------------------------------------------////

void Rule::addReplacement(const Replacement& r)
{
    mReplacements.push_back(r);
}

