// primShape.h
// Context Free
// ---------------------
// Copyright (C) 2006 John Horigan
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// John Horigan can be contacted at john@glyphic.com or at
// John Horigan, 1209 Villa St., Mountain View, CA 94041-1123, USA
//
//

#ifndef INCLUDE_PRIMSHAPE_H
#define INCLUDE_PRIMSHAPE_H

class primShape
{
	public:
		enum {circleType = 0, squareType = 1, triangleType = 2};
		primShape(const double* x, const double* y, unsigned v) : mX(x), mY(y), mVertex(v) {}
		bool vertex(double* x, double* y, unsigned n) const
		{
			if (n >= mVertex) return false;
			*x = mX[n];
			*y = mY[n];
			return true;
		}
		
		static primShape circle;
		static primShape square;
		static primShape triangle;
        static primShape* shapeMap[3];
        static bool isPrimShape(unsigned v) { return v < 3; }
		
	private:
		const double* mX;
		const double* mY;
		const unsigned mVertex;
        primShape& operator=(primShape& s) { return s; }
};
	
#endif // INCLUDE_PRIMSHAPE_H
