/*
 *  based on countable from 
 *      Wheat -- http://www.wheatfarm.org/
 */

#ifndef INCULDE_COUNTABLE_H
#define INCULDE_COUNTABLE_H

template <class C> class ref_ptr;

class Countable {
protected:
    Countable() : mUseCount(0) { }
    virtual ~Countable();

    template <class C>
    static ref_ptr<C> build(C* p) { return ref_ptr<C>(p); }

public:
    class RefPtr {
    protected:
        static void adjust(Countable* pointer, Countable* value);
    };
    
private:
    int mUseCount;
    friend class RefPtr;
};


inline void
Countable::RefPtr::adjust(Countable* pointer, Countable* value)
{
    if (value)      ++value->mUseCount;
    if (pointer)    if (--pointer->mUseCount == 0) delete pointer;
}


template <class C>
class ref_ptr : private Countable::RefPtr {
private:
    C* ptr;
    void assign(C* p) { RefPtr::adjust(ptr, p); ptr = p; }
    
public:
    ref_ptr()                   : ptr(0)    { }
    ref_ptr(const ref_ptr& r)   : ptr(0)    { assign(r.ptr); }
    ~ref_ptr()                              { assign(0); }
    ref_ptr& operator=(const ref_ptr& r)
        { assign(r.ptr); return *this; }

    C& operator*()  const { return *ptr; }
    C* operator->() const { return ptr; }
    C* get()        const { return ptr; }

#ifndef WIN32
    template <class D>
    ref_ptr(const ref_ptr<D>& r)
        : ptr(0) { assign(r.get()); }

    template <class D>
    ref_ptr& operator=(const ref_ptr<D>& r)
        { assign(r.get()); return *this; }
#endif // !WIN32

private:
    friend class Countable;
    explicit ref_ptr(C* p) : ptr(0) { assign(p); }
};


#endif // INCULDE_COUNTABLE_H
