/*
 *  cfdgimpl.h
 *  Context Free
 *
 *  Created by Mark Lentczner on 2006-02-18.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_CFDGIMPL_H
#define INCLUDE_CFDGIMPL_H

#include <string>
#include <vector>

#include "agg_color_rgba.h"
#include "cfdg.h"
#include "shape.h"

class CFDGImpl : public CFDG {
    private:
        Shape m_initialShape;
        agg::rgba m_BackgroundColor;
        bool mBackgroundSet;

        std::vector<Rule> mRules;
        
        struct ShapeType {
            std::string  name;
            bool    hasRules;
            
            ShapeType(const std::string& s) : name(s), hasRules(false) { }
        };
        
        std::vector<ShapeType> m_shapeTypes;
        
        System* m_system;

        int m_Parameters;

        double m_minSize;
        double m_minArea;
        
        agg::trans_affine mTileTransform;
        double mTileX, mTileY;
        bool mTiled;
        bool mSized;
        agg::point_d mTileOffset;
        
    public:
        CFDGImpl(System*);
        virtual ~CFDGImpl();
        
        virtual Renderer* renderer(
                int width, int height, float minSize,
                int variation, double border = 2.0);
        
        bool usesColor() const;
        bool usesAlpha() const;
        bool isTiled(agg::trans_affine* tr = 0, double* x = 0, double* y = 0) const;
        bool isSized(double* x = 0, double* y = 0) const;

        agg::rgba backgroundColor() const;
		
    public:
        System* system() { return m_system; }
        
        void            setInitialShape(const Shape& s);
        const Shape&    getInitialShape();
        
        void addRule(const Rule& r);
        void rulesLoaded();
        int numRules();
        Rule * findRule(int shapetype, double r);

        std::string  decodeShapeName(int shapetype);
        int     encodeShapeName(const std::string& s);
        bool    shapeHasRules(int shapetype);

        enum Parameter {Color = 1, Alpha = 2};
        void addParameter(Parameter);

        void setBackgroundColor(const agg::rgba& bk);
        void setTiled(const agg::trans_affine& tr, const double& x, const double& y);
        void setSized(const agg::trans_affine& tr);
};



#endif // INCLUDE_CFDGIMPL_H
