#ifndef INCLUDE_BUILDER_H
#define INCLUDE_BUILDER_H

#ifdef _WIN32
#pragma warning( disable : 4786 )
#endif

#include <iostream>
#include <queue>
#include <string>

#include "shape.h"

class CFDGImpl;

class Builder {
    public:
        CFDGImpl*       m_CFDG;
        std::queue<std::string>   m_filesToLoad;
        std::string          m_currentPath;
        
        std::istream*        m_input;
        
        int             mShapeType;
        Modification    mCurrentModification;
        Modification    mSavedModification;
        double          mOrientation;
        double          mReflection;
        bool            mReflected;
        double          mSizeX;
        double          mSizeY;
        double          mSizeZ;
        double          mSkewX;
        double          mSkewY;
        double          mXLocation;
        double          mYLocation;
        double          mZLocation;
        Rule            m_currRule;

        void addEntropy(const char* txt);
		static unsigned ModSeedIndex;

        
        Builder(CFDGImpl* cfdg)
            : m_CFDG(cfdg), m_input(0), mOrientation(0.0), mReflection(0.0), 
              mReflected(false), mSizeX(1.0), mSizeY(1.0), mSizeZ(1.0), 
              mSkewX(0.0), mSkewY(0.0), mXLocation(0.0), mYLocation(0.0), 
              mZLocation(0.0)
        { }
        ~Builder();

        void            Orientation(double);
        void            Reflection(double);
        void            Size(double, double, double);
        void            Skew(double, double);
        void            XLocation(double);
        void            YLocation(double);
        void            ZLocation(double);

        void            buildDefaultTransform();
        const char*     buildTileTransform();
        const char*     buildSizeTransform();
        void            clearModification();
};

#endif // INCLUDE_BUILDER_H
