/*
 *  SVGCanvas.h
 *  Context Free
 *
 *  Created by John Horigan on Jan. 20, 2006.
 *  Copyright 2006 John Horigan. All rights reserved.
 *
 */

#include <iostream>
#include <fstream>
#include <string>
#include "agg_trans_affine.h"
#include "agg_color_rgba.h"
#include "cfdg.h"

class SVGCanvas : public Canvas {
    public:
        void start(bool clear, const agg::rgba& bk, int width, int height);
        void end();

        void complete(RGBA8 c, agg::trans_affine tr, int padding);
        void circle(RGBA8 c, agg::trans_affine tr);
        void square(RGBA8 c, agg::trans_affine tr);
        void triangle(RGBA8 c, agg::trans_affine tr);

        SVGCanvas(const char* opath, int width, int height, bool crop, const char* desc = 0, int length = -1);

    private:
        agg::trans_affine mOffset;
        bool mCropped;
        std::ofstream mOutput;
        const char* mDescription;
        int mLength;
    
};

