#!/usr/bin/env python

import os, sys
from distutils.core import setup
from distutils.extension import Extension

setup (# Information about this distribution
        name = "My Transcoding Software",
        version = "1.0.0",
        description = "An C interface to Transcoding Software",
        author = "Chen Chien-Hsun",
        author_email = "frank63@ms5.hinet.net",
        url = "",
        py_modules = [
                     "chinesetw.__init__",
                     "chinesetw.big52utf1",
                     "chinesetw.big52utf2",
                     "chinesetw.utf2big51",
                     "chinesetw.utf2big52",
                     "chinesecn.__init__",
                     "chinesecn.euc_gb23122utf",
                     "chinesecn.utf2euc_gb2312",
                     ],

        ext_modules = [Extension(
                name = 'big5module',
                sources = ['big5module.c'],),
                Extension(
                name = 'gb2312module',
                sources = ['gb2312module.c'],
                )], 
)
