/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class ColumnLayout
implements LayoutManager {
    public static final int X_AXIS = 120;
    public static final int Y_AXIS = 121;
    protected final int alignment;
    protected final int hPadding;
    protected final int vPadding;
    protected int minw;
    protected int minh;
    Component[] curComps;

    public ColumnLayout(int dirn) {
        this(dirn, 0, 0);
    }

    public ColumnLayout(int dirn, int pad) {
        this(dirn, pad, pad);
    }

    public ColumnLayout(int dirn, int hpad, int vpad) {
        this.alignment = dirn;
        this.hPadding = hpad;
        this.vPadding = vpad;
    }

    public void addLayoutComponent(String name, Component c) {
        System.err.println("don't use add(component,name) with ColumnLayout");
    }

    public void layoutContainer(Container target) {
        this.doLayout(target);
    }

    protected Dimension doLayout(Container target) {
        this.minh = 0;
        this.minw = 0;
        this.curComps = target.getComponents();
        int i = 0;
        while (i < this.curComps.length) {
            Component tc = this.curComps[i];
            Dimension d = tc.getPreferredSize();
            this.minw = Math.max(this.minw, d.width);
            this.minh = Math.max(this.minh, d.height);
            ++i;
        }
        int x = this.hPadding;
        int y = this.vPadding;
        int i2 = 0;
        while (i2 < this.curComps.length) {
            int cy;
            int cx;
            int ch;
            int cw;
            Component tc = this.curComps[i2];
            Dimension d = tc.getPreferredSize();
            switch (this.alignment) {
                case 120: {
                    cw = tc instanceof Spacer ? d.width : this.minw;
                    ch = this.minh;
                    cx = x;
                    x += cw + this.hPadding;
                    cy = this.vPadding;
                    y = ch;
                    break;
                }
                case 121: {
                    cw = this.minw;
                    ch = tc instanceof Spacer ? d.height : this.minh;
                    cx = this.hPadding;
                    x = cw;
                    cy = y;
                    y += ch + this.vPadding;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid alignment");
                }
            }
            tc.setBounds(cx, cy, cw, ch);
            ++i2;
        }
        switch (this.alignment) {
            case 120: {
                return new Dimension(x, y + 2 * this.vPadding);
            }
            case 121: {
                return new Dimension(x + 2 * this.hPadding, y);
            }
        }
        throw new IllegalArgumentException("Invalid alignment");
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.doLayout(target);
    }

    public Dimension preferredLayoutSize(Container target) {
        System.out.println("preferredLayoutSize() called");
        return this.doLayout(target);
    }

    public void addSpacer(Container target) {
        target.add(new Spacer());
    }

    public void removeLayoutComponent(Component c) {
    }

    protected static class Spacer
    extends Component {
        private static final long serialVersionUID = -7583095138638433618L;

        protected Spacer() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(10, 10);
        }
    }
}

