/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CompressingFilter
implements Filter {
    public void init(FilterConfig arg0) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            String acceptableEncodings = request.getHeader("accept-encoding");
            if (acceptableEncodings != null && acceptableEncodings.indexOf("gzip") != -1) {
                GZipResponseWrapper wrappedResponse = new GZipResponseWrapper((ServletResponse)response);
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                return;
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
    }

    static class GZipResponseWrapper
    extends ServletResponseWrapper {
        public GZipResponseWrapper(ServletResponse ressponse) {
            super(ressponse);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new MyServletOutputStream(new GZIPOutputStream((OutputStream)super.getOutputStream()));
        }

        static class MyServletOutputStream
        extends ServletOutputStream {
            private OutputStream os;

            MyServletOutputStream(GZIPOutputStream os) {
                this.os = os;
            }

            public void write(int arg0) throws IOException {
                this.os.write(arg0);
            }
        }
    }
}

