/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mailer {
    protected Session session;
    protected String from;
    protected String subject;
    protected List<String> toList = new ArrayList<String>();
    protected List<String> ccList = new ArrayList<String>();
    protected List<String> bccList = new ArrayList<String>();
    protected String body;
    protected String mailHost;
    protected boolean verbose;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String fm) {
        this.from = fm;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public List<String> getToList() {
        return this.toList;
    }

    public void setToList(ArrayList<String> to) {
        this.toList = to;
    }

    public void setToList(String s) {
        this.toList = this.tokenize(s);
    }

    public void addTo(String to) {
        this.toList.add(to);
    }

    public List<String> getCcList() {
        return this.ccList;
    }

    public void setCcList(ArrayList<String> cc) {
        this.ccList = cc;
    }

    public void setCcList(String s) {
        this.ccList = this.tokenize(s);
    }

    public void addCc(String cc) {
        this.ccList.add(cc);
    }

    public List<String> getBccList() {
        return this.bccList;
    }

    public void setBccList(List<String> bcc) {
        this.bccList = bcc;
    }

    public void setBccList(String s) {
        this.bccList = this.tokenize(s);
    }

    public void addBcc(String bcc) {
        this.bccList.add(bcc);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String text) {
        this.body = text;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public boolean isComplete() {
        if (this.from == null || this.from.length() == 0) {
            System.err.println("doSend: no FROM");
            return false;
        }
        if (this.subject == null || this.subject.length() == 0) {
            System.err.println("doSend: no SUBJECT");
            return false;
        }
        if (this.toList.size() == 0) {
            System.err.println("doSend: no recipients");
            return false;
        }
        if (this.body == null || this.body.length() == 0) {
            System.err.println("doSend: no body");
            return false;
        }
        if (this.mailHost == null || this.mailHost.length() == 0) {
            System.err.println("doSend: no server host");
            return false;
        }
        return true;
    }

    public void setServer(String s) {
        this.mailHost = s;
    }

    public synchronized void doSend() throws MessagingException {
        if (!this.isComplete()) {
            throw new IllegalArgumentException("doSend called before message was complete");
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.mailHost);
        if (this.session == null) {
            this.session = Session.getDefaultInstance((Properties)props, null);
            if (this.verbose) {
                this.session.setDebug(true);
            }
        }
        MimeMessage mesg = new MimeMessage(this.session);
        InternetAddress[] addresses = new InternetAddress[this.toList.size()];
        int i = 0;
        while (i < addresses.length) {
            addresses[i] = new InternetAddress(this.toList.get(i));
            ++i;
        }
        mesg.setRecipients(Message.RecipientType.TO, (Address[])addresses);
        mesg.setFrom((Address)new InternetAddress(this.from));
        addresses = new InternetAddress[this.ccList.size()];
        i = 0;
        while (i < addresses.length) {
            addresses[i] = new InternetAddress(this.ccList.get(i));
            ++i;
        }
        mesg.setRecipients(Message.RecipientType.CC, (Address[])addresses);
        addresses = new InternetAddress[this.bccList.size()];
        i = 0;
        while (i < addresses.length) {
            addresses[i] = new InternetAddress(this.bccList.get(i));
            ++i;
        }
        mesg.setRecipients(Message.RecipientType.BCC, (Address[])addresses);
        mesg.setSubject(this.subject);
        mesg.setText(this.body);
        Transport.send((Message)mesg);
    }

    public static void send(String mailhost, String recipient, String sender, String subject, String message) throws MessagingException {
        Mailer m = new Mailer();
        m.setServer(mailhost);
        m.addTo(recipient);
        m.setFrom(sender);
        m.setSubject(subject);
        m.setBody(message);
        m.doSend();
    }

    protected List<String> tokenize(String s) {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer tf = new StringTokenizer(s, ",");
        while (tf.hasMoreTokens()) {
            al.add(tf.nextToken().trim());
        }
        return al;
    }
}

