/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleTagValidator {
    private static final String[] OKTAGS = new String[]{"a", "b", "br", "em", "i", "p"};
    private final String[] okTags;
    private final Pattern patt = Pattern.compile("<\\s*/?(\\w+)");
    private String failedTag = null;

    public SimpleTagValidator() {
        this.okTags = OKTAGS;
    }

    public SimpleTagValidator(String[] okTagList) {
        this.okTags = new String[okTagList.length];
        System.arraycopy(okTagList, 0, this.okTags, 0, okTagList.length);
    }

    public boolean validate(String s) {
        if (s == null) {
            throw new NullPointerException("validate: null input");
        }
        this.failedTag = null;
        Matcher m = this.patt.matcher(s);
        while (m.find()) {
            String tagName = m.group(1);
            System.out.println(tagName);
            if (this.okTag(tagName)) continue;
            this.failedTag = tagName;
            return false;
        }
        return true;
    }

    private boolean okTag(String tagName) {
        int i = 0;
        while (i < this.okTags.length) {
            if (this.okTags[i].equalsIgnoreCase(tagName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getFailedTag() {
        return this.failedTag;
    }

    public String getTagsAsString(boolean useCommas) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.okTags.length) {
            sb.append(this.okTags[i]);
            if (i < this.okTags.length - 1) {
                if (useCommas) {
                    sb.append(',');
                }
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }
}

