/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.qfa.ExceptionReport;
import ca.sqlpower.architect.qfa.QFAFactory;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.StatusIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASUtils {
    private static final Logger logger = Logger.getLogger(ASUtils.class);
    public static final FileFilter ARCHITECT_FILE_FILTER = new FileExtensionFilter("Architect Project Files", new String[]{"arc", "architect"});
    public static final FileFilter TEXT_FILE_FILTER = new FileExtensionFilter("Text Files ", new String[]{"txt"});
    public static final FileFilter SQL_FILE_FILTER = new FileExtensionFilter("SQL Script Files", new String[]{"sql", "ddl"});
    public static final FileFilter INI_FILE_FILTER = new FileExtensionFilter(".INI Files", new String[]{"ini"});
    public static final FileFilter EXE_FILE_FILTER = new FileExtensionFilter(".EXE Files", new String[]{"exe"});
    public static final FileFilter JAR_ZIP_FILE_FILTER = new FileExtensionFilter("Java JAR Files", new String[]{"jar", "zip"});
    public static final FileFilter LOG_FILE_FILTER = new FileExtensionFilter("Log Files", new String[]{"log"});
    public static final FileFilter XML_FILE_FILTER = new FileExtensionFilter("XML Files", new String[]{"xml"});
    public static final FileFilter PDF_FILE_FILTER = new FileExtensionFilter("Portable Document (PDF) Files", new String[]{"pdf"});
    public static final FileFilter CSV_FILE_FILTER = new FileExtensionFilter("Comma-Separated Value Files", new String[]{"csv"});
    public static final FileFilter HTML_FILE_FILTER = new FileExtensionFilter("HTML Files", new String[]{"html"});
    public static final FileFilter BATCH_FILE_FILTER = new FileExtensionFilter("Batch Scripts", new String[]{"bat"});
    private Thread focusDebuggerThread = null;
    private boolean focusDebuggerStopping = true;
    private Runnable showFocusOwnerTask = new Runnable(){

        public void run() {
            while (!ASUtils.this.focusDebuggerStopping) {
                logger.debug((Object)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"Interrupted in sleep");
                }
            }
            ASUtils.this.focusDebuggerThread = null;
        }
    };
    static ImageIcon masterIcon;
    static final int MAX_JRE_ELEMENTS = 10;
    static final int THRESHOLD = 5;

    private ASUtils() {
    }

    public static LabelValueBean lvb(String label, Object value) {
        return new LabelValueBean(label, value);
    }

    public static double distance(Point p1, Point p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static ImageIcon createJLFIcon(String name, String description, int size) {
        String realPath = "/toolbarButtonGraphics/" + name + size + ".gif";
        logger.debug((Object)("Loading resource " + realPath));
        URL imgURL = ASUtils.class.getResource(realPath);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        logger.debug((Object)("Couldn't find file: " + realPath));
        return null;
    }

    public static ImageIcon createIcon(String name, String description, int size) {
        return ASUtils.createIcon(name + size, description);
    }

    public static ImageIcon createIcon(String name, String description) {
        String realPath = "/icons/" + name + ".png";
        logger.debug((Object)("Loading resource " + realPath));
        URL imgURL = ASUtils.class.getResource(realPath);
        if (imgURL == null) {
            realPath = realPath.replace(".png", ".gif");
            imgURL = ASUtils.class.getResource(realPath);
        }
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        logger.debug((Object)("Couldn't find file: " + realPath));
        return null;
    }

    public void stopFocusDebugger() {
        this.focusDebuggerStopping = true;
    }

    public void startFocusDebugger() {
        this.focusDebuggerThread = new Thread(this.showFocusOwnerTask);
        this.focusDebuggerStopping = false;
        this.focusDebuggerThread.start();
    }

    public static void makeJDialogCancellable(final Window w, final Action cancelAction, final boolean disposeOnCancel) {
        JRootPane c;
        if (w instanceof JFrame) {
            c = ((JFrame)w).getRootPane();
        } else if (w instanceof JDialog) {
            c = ((JDialog)w).getRootPane();
        } else {
            throw new IllegalArgumentException("The window argument has to be either a JFrame or JDialog.  You provided a " + (w == null ? null : w.getClass().getName()));
        }
        InputMap inputMap = c.getInputMap(1);
        ActionMap actionMap = c.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
        actionMap.put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (cancelAction != null) {
                    cancelAction.actionPerformed(e);
                }
                if (disposeOnCancel) {
                    w.dispose();
                }
            }
        });
    }

    public static void makeJDialogCancellable(Window w, Action cancelAction) {
        ASUtils.makeJDialogCancellable(w, cancelAction, true);
    }

    public static void showExceptionDialog(String message, Throwable throwable) {
        ASUtils.showExceptionDialog(ArchitectFrame.getMainInstance(), message, throwable, new ArchitectExceptionReportFactory());
    }

    public static void showExceptionDialog(Component parent, String message, Throwable throwable, QFAFactory qfaFactory) {
        ASUtils.showExceptionDialog(parent, message, null, throwable, qfaFactory);
    }

    public static void showExceptionDialog(Component parent, String message, String subMessage, Throwable throwable, QFAFactory qfaFactory) {
        ASUtils.showExceptionDialog(ArchitectFrame.getMainInstance(), parent, message, subMessage, throwable, qfaFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showExceptionDialog(ArchitectFrame architectFrame, Component parent, String message, String subMessage, Throwable throwable, QFAFactory qfaFactory) {
        try {
            ExceptionReport er = qfaFactory.createExceptionReport(throwable);
            if (architectFrame != null) {
                er.setNumObjectsInPlayPen(architectFrame.playpen.getTablePanes().size() + architectFrame.playpen.getRelationships().size());
                er.setNumSourceConnections(architectFrame.dbTree.getDatabaseList().size());
            }
            er.setUserActivityDescription("");
            logger.debug((Object)er.toString());
            er.postReport();
        }
        catch (Throwable seriousProblem) {
            logger.error((Object)"Couldn't generate and send exception report!  Note that this is not the primary problem; it's a side effect of trying to report the real problem.", seriousProblem);
            JOptionPane.showMessageDialog(null, "Error reporting failed: " + seriousProblem.getMessage() + "\nAdditional information is available in the application log.");
        }
        finally {
            ASUtils.displayExceptionDialog(parent, message, subMessage, throwable);
        }
    }

    public static void showExceptionDialogNoReport(String string, Throwable ex) {
        ASUtils.displayExceptionDialog(ArchitectFrame.getMainInstance(), string, null, ex);
    }

    public static void showExceptionDialogNoReport(Component parent, String message, String subMessage, Throwable throwable) {
        ASUtils.displayExceptionDialog(parent, message, subMessage, throwable);
    }

    public static void showExceptionDialogNoReport(Component parent, String string, Throwable ex) {
        ASUtils.displayExceptionDialog(parent, string, null, ex);
    }

    private static void displayExceptionDialog(Component parent, String message, String subMessage, Throwable throwable) {
        JDialog dialog;
        if (parent instanceof JFrame) {
            JFrame frame = (JFrame)parent;
            dialog = new JDialog((Frame)frame, "Error Report");
            if (masterIcon != null) {
                frame.setIconImage(masterIcon.getImage());
            }
        } else if (parent instanceof Dialog) {
            dialog = new JDialog((Dialog)parent, "Error Report");
        } else {
            logger.error((Object)String.format("dialog parent component %s is neither JFrame nor JDialog", parent));
            dialog = new JDialog((Frame)null, "Error report");
        }
        logger.debug((Object)"displayExceptionDialog: showing exception dialog for:", throwable);
        ((JComponent)dialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        Throwable t = throwable;
        StringWriter stringWriter = new StringWriter();
        PrintWriter traceWriter = new PrintWriter(stringWriter);
        do {
            ASUtils.printStackTrace(t, traceWriter);
            t = t.getCause();
            if (t == null) continue;
            traceWriter.println("Caused by:");
        } while (t != null);
        traceWriter.close();
        JPanel top = new JPanel(new GridLayout(0, 1, 5, 5));
        StringBuilder labelText = new StringBuilder();
        labelText.append("<html><font color='red' size='+1'>");
        labelText.append(message == null ? "Unexpected error" : ASUtils.nlToBR(message));
        labelText.append("</font>");
        if (subMessage != null) {
            labelText.append("<p>");
            labelText.append(subMessage);
        }
        JLabel messageLabel = new JLabel(labelText.toString());
        messageLabel.setIcon(StatusIcon.getFailIcon());
        top.add(messageLabel);
        JLabel errClassLabel = new JLabel("<html><b>Exception type</b>: " + ASUtils.nlToBR(throwable.getClass().getName()));
        top.add(errClassLabel);
        String excDetailMessage = throwable.getMessage();
        if (excDetailMessage != null) {
            top.add(new JLabel("<html><b>Detail string</b>: " + ASUtils.nlToBR(excDetailMessage)));
        }
        final JButton detailsButton = new JButton("Show Details");
        JPanel detailsButtonPanel = new JPanel();
        detailsButtonPanel.add(detailsButton);
        JButton forumButton = new JButton(ArchitectFrame.forumAction);
        detailsButtonPanel.add(forumButton);
        top.add(detailsButtonPanel);
        dialog.add((Component)top, "North");
        JScrollPane detailScroller = new JScrollPane(new JTextArea(stringWriter.toString()));
        final JPanel messageComponent = new JPanel(new BorderLayout());
        messageComponent.add((Component)detailScroller, "Center");
        messageComponent.setPreferredSize(new Dimension(700, 400));
        final JComponent fakeMessageComponent = new JComponent(){

            public Dimension getPreferredSize() {
                return new Dimension(700, 0);
            }
        };
        final JDialog finalDialogReference = dialog;
        finalDialogReference.add((Component)fakeMessageComponent, "Center");
        ActionListener detailsAction = new ActionListener(){
            boolean showDetails = true;

            public void actionPerformed(ActionEvent e) {
                if (this.showDetails) {
                    finalDialogReference.remove(fakeMessageComponent);
                    finalDialogReference.add((Component)messageComponent, "Center");
                    detailsButton.setText("Hide Details");
                } else {
                    finalDialogReference.remove(messageComponent);
                    finalDialogReference.add((Component)fakeMessageComponent, "Center");
                    detailsButton.setText("Show Details");
                }
                finalDialogReference.pack();
                Rectangle dialogBounds = finalDialogReference.getBounds();
                Rectangle screenBounds = finalDialogReference.getGraphicsConfiguration().getBounds();
                if (!screenBounds.contains(dialogBounds)) {
                    int x = dialogBounds.x;
                    int y = dialogBounds.y;
                    if (screenBounds.x + screenBounds.width < dialogBounds.x + dialogBounds.width) {
                        x = dialogBounds.x - (dialogBounds.x + dialogBounds.width - screenBounds.x - screenBounds.width);
                    }
                    if (screenBounds.y + screenBounds.height < dialogBounds.y + dialogBounds.height) {
                        y = dialogBounds.y - (dialogBounds.y + dialogBounds.height - screenBounds.y - screenBounds.height);
                    }
                    if (screenBounds.x > x) {
                        x = screenBounds.x;
                    }
                    if (screenBounds.y > y) {
                        y = screenBounds.y;
                    }
                    finalDialogReference.setLocation(x, y);
                }
                this.showDetails = !this.showDetails;
            }
        };
        detailsButton.addActionListener(detailsAction);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                finalDialogReference.dispose();
                finalDialogReference.setVisible(false);
            }
        });
        JPanel bottom = new JPanel();
        bottom.add(okButton);
        dialog.add((Component)bottom, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    static String nlToBR(String s) {
        return s.replaceAll("\n", "<br>");
    }

    static void printStackTrace(Throwable throwable, PrintWriter traceWriter) {
        traceWriter.println(throwable);
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int jreElements = 0;
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement e = stackTrace[i];
            traceWriter.print("\t");
            traceWriter.println(e);
            String clazzName = e.getClassName();
            if (!clazzName.startsWith("java.") && !clazzName.startsWith("javax.") && !clazzName.startsWith("sun.") && !clazzName.startsWith("org.")) continue;
            int remainingLength = stackTrace.length - i;
            if (++jreElements < 10 || remainingLength <= 5) continue;
            traceWriter.printf("\t... %d more...%n", remainingLength);
            break;
        }
        traceWriter.flush();
    }

    public static String lineToString(Line2D.Double l) {
        return "[(" + l.x1 + "," + l.y1 + ") - (" + l.x2 + "," + l.y2 + ")]";
    }

    public static List<Point2D.Double> getIntersectPoints(Shape s1, Shape s2) {
        ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
        PathIterator myPI = s1.getPathIterator(null);
        Line2D.Double myLine = new Line2D.Double();
        float[] myCoords = new float[6];
        while (!myPI.isDone()) {
            int mySegType = myPI.currentSegment(myCoords);
            if (mySegType == 1) {
                myLine.x1 = myLine.x2;
                myLine.y1 = myLine.y2;
                myLine.x2 = myCoords[0];
                myLine.y2 = myCoords[1];
            } else if (mySegType == 0 || mySegType == 4) {
                myLine.x1 = myCoords[0];
                myLine.y1 = myCoords[1];
                myLine.x2 = myCoords[0];
                myLine.y2 = myCoords[1];
            } else {
                throw new IllegalStateException("Unsupported my PathIterator type " + mySegType + ". Current myLine is " + ASUtils.lineToString(myLine));
            }
            myPI.next();
            if (myLine.x1 == myLine.x2 && myLine.y1 == myLine.y2) continue;
            PathIterator otherPI = s2.getPathIterator(null);
            Line2D.Double otherLine = new Line2D.Double();
            float[] otherCoords = new float[6];
            while (!otherPI.isDone()) {
                Point2D.Double point;
                int otherSegType = otherPI.currentSegment(otherCoords);
                if (otherSegType == 1) {
                    otherLine.x1 = otherLine.x2;
                    otherLine.y1 = otherLine.y2;
                    otherLine.x2 = otherCoords[0];
                    otherLine.y2 = otherCoords[1];
                } else if (otherSegType == 0 || otherSegType == 4) {
                    otherLine.x1 = otherCoords[0];
                    otherLine.y1 = otherCoords[1];
                    otherLine.x2 = otherCoords[0];
                    otherLine.y2 = otherCoords[1];
                } else {
                    throw new IllegalStateException("Unsupported other PathIterator type " + otherSegType + ". Current otherLine is " + ASUtils.lineToString(otherLine));
                }
                otherPI.next();
                if (otherLine.x1 == otherLine.x2 && otherLine.y1 == otherLine.y2 || !ASUtils.getLineLineIntersection(myLine, otherLine, point = new Point2D.Double())) continue;
                list.add(point);
            }
        }
        return list;
    }

    public static boolean getLineLineIntersection(Line2D.Double l1, Line2D.Double l2, Point2D.Double intersection) {
        if (!l1.intersectsLine(l2)) {
            return false;
        }
        double x1 = l1.getX1();
        double y1 = l1.getY1();
        double x2 = l1.getX2();
        double y2 = l1.getY2();
        double x3 = l2.getX1();
        double y3 = l2.getY1();
        double x4 = l2.getX2();
        double y4 = l2.getY2();
        intersection.x = ASUtils.det(ASUtils.det(x1, y1, x2, y2), x1 - x2, ASUtils.det(x3, y3, x4, y4), x3 - x4) / ASUtils.det(x1 - x2, y1 - y2, x3 - x4, y3 - y4);
        intersection.y = ASUtils.det(ASUtils.det(x1, y1, x2, y2), y1 - y2, ASUtils.det(x3, y3, x4, y4), y3 - y4) / ASUtils.det(x1 - x2, y1 - y2, x3 - x4, y3 - y4);
        return true;
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    public static String niceClassName(Object o) {
        Class<?> c = o.getClass();
        String name = c.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1);
    }

    public static void breakLongMenu(Window frame, JMenu input) {
        if (input.getItemCount() <= 0) {
            return;
        }
        int windowHeight = frame.getSize().height;
        int totalRows = input.getItemCount();
        int preferredHeight = input.getItem((int)0).getPreferredSize().height;
        int FUDGE = 3;
        int rowsPerSubMenu = windowHeight / preferredHeight - 3;
        if (rowsPerSubMenu < 3) {
            rowsPerSubMenu = 3;
        }
        if (totalRows <= rowsPerSubMenu) {
            return;
        }
        JMenu parentMenu = input;
        JMenu subMenu = new JMenu("More...");
        parentMenu.add(subMenu);
        while (input.getItemCount() > rowsPerSubMenu + 1) {
            JMenuItem item = input.getItem(rowsPerSubMenu);
            subMenu.add(item);
            if (subMenu.getItemCount() < rowsPerSubMenu || input.getItemCount() <= rowsPerSubMenu + 1) continue;
            parentMenu = subMenu;
            subMenu = new JMenu("More...");
            parentMenu.add(subMenu);
        }
    }

    public static Image getFrameIconImage() {
        return ASUtils.createIcon("Architect", "Architect Logo", 16).getImage();
    }

    public static class FileExtensionFilter
    extends FileFilter {
        protected LinkedHashSet<String> extensions;
        protected String name;

        public FileExtensionFilter(String name, String[] extensions) {
            this.name = name;
            this.extensions = new LinkedHashSet<String>(Arrays.asList(extensions));
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(this.name);
            s.append(":");
            s.append(this.extensions.toString());
            return s.toString();
        }

        public boolean accept(File f) {
            return f.isDirectory() || this.extensions.contains(FileExtensionFilter.getExtension(f));
        }

        public String getDescription() {
            return this.name;
        }

        public static String getExtension(File f) {
            String ext = "";
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        public String getFilterExtension(Integer index) {
            ArrayList<String> l = new ArrayList<String>(this.extensions);
            int i = index == null || index < 0 || index >= l.size() ? 0 : index;
            if (l.size() > 0) {
                return (String)l.get(i);
            }
            return null;
        }
    }

    public static class LabelValueBean {
        String label;
        Object value;

        public LabelValueBean(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String argLabel) {
            this.label = argLabel;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object argValue) {
            this.value = argValue;
        }

        public String toString() {
            return this.label;
        }
    }
}

