/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.Monitorable;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.DDLUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConflictResolver
implements Monitorable {
    private static final Logger logger = Logger.getLogger(ConflictResolver.class);
    private SQLDatabase targetDatabase;
    private List ddlStatements;
    private List conflicts;
    private String lastSQLStatement;
    private DDLGenerator ddlg;
    private int monitorableProgress;
    private boolean doingFindConflicting;
    private boolean findConflictingFinished;
    private boolean doingDropConflicting;
    private boolean dropConflictingStarted;
    private boolean dropConflictingFinished;

    public ConflictResolver(SQLDatabase target, DDLGenerator ddlg, List ddlStatements) throws SQLException {
        this.targetDatabase = target;
        this.ddlg = ddlg;
        this.ddlStatements = ddlStatements;
    }

    public void aboutToCallDropConflicting() {
        this.dropConflictingStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findConflicting() throws SQLException, ArchitectException {
        this.doingFindConflicting = true;
        Connection con = null;
        try {
            this.conflicts = new ArrayList();
            this.monitorableProgress = 0;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to find conflicting objects for DDL Script: " + this.ddlStatements));
            }
            con = this.targetDatabase.getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            for (DDLStatement ddlStmt : this.ddlStatements) {
                ++this.monitorableProgress;
                if (ddlStmt.getType() != DDLStatement.StatementType.CREATE) continue;
                SQLObject so = ddlStmt.getObject();
                Class<?> clazz = so.getClass();
                if (clazz.equals(SQLTable.class)) {
                    SQLTable t = (SQLTable)so;
                    String cat = ddlStmt.getTargetCatalog();
                    String sch = ddlStmt.getTargetSchema();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Finding conflicts for TABLE '" + cat + "'.'" + sch + "'.'" + t.getPhysicalName() + "'"));
                    }
                    ResultSet rs = dbmd.getTables(this.ddlg.toIdentifier(cat), this.ddlg.toIdentifier(sch), this.ddlg.toIdentifier(t.getPhysicalName()), null);
                    while (rs.next()) {
                        Conflict c = new Conflict(rs.getString("TABLE_TYPE"), rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"));
                        this.ddlg.setTargetCatalog(c.getCatalog());
                        this.ddlg.setTargetSchema(c.getSchema());
                        c.setSqlDropStatement(this.ddlg.makeDropTableSQL(c.getName()));
                        c.addTableDependants(dbmd);
                        this.conflicts.add(c);
                    }
                    rs.close();
                    continue;
                }
                if (clazz.equals(SQLRelationship.class)) {
                    logger.error((Object)"Relationship conflicts are not supported yet!");
                    continue;
                }
                if (clazz.equals(SQLIndex.class)) {
                    logger.error((Object)"Index conflicts not supported.");
                    continue;
                }
                throw new IllegalArgumentException("Unknown subclass of SQLObject: " + clazz.getName());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found conflicts: " + this.conflicts));
            }
        }
        finally {
            this.findConflictingFinished = true;
            this.doingFindConflicting = false;
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConflicting() throws SQLException, ArchitectException {
        if (this.conflicts == null) {
            throw new IllegalStateException("You have to call findConflicting() before dropConflicting()");
        }
        this.monitorableProgress = 0;
        this.dropConflictingStarted = true;
        this.doingDropConflicting = true;
        Iterator it = this.conflicts.iterator();
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.targetDatabase.getConnection();
            stmt = con.createStatement();
            HashSet alreadyDropped = new HashSet();
            while (it.hasNext()) {
                Conflict c = (Conflict)it.next();
                ++this.monitorableProgress;
                this.dropConflict(c, stmt, alreadyDropped);
            }
        }
        finally {
            this.dropConflictingFinished = true;
            this.doingDropConflicting = false;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close statement", (Throwable)ex);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close connection", (Throwable)ex);
            }
        }
    }

    private void dropConflict(Conflict c, Statement stmt, Set alreadyDropped) throws SQLException {
        for (Conflict c2 : c.getDependants()) {
            this.dropConflict(c2, stmt, alreadyDropped);
        }
        if (!alreadyDropped.contains(c)) {
            alreadyDropped.add(c);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dropping conflict " + c + " with SQL: " + c.getSqlDropStatement()));
            }
            this.lastSQLStatement = c.getSqlDropStatement();
            stmt.executeUpdate(c.getSqlDropStatement());
        }
    }

    public boolean isEmpty() {
        if (this.conflicts == null) {
            throw new IllegalStateException("You have to call findConflicting() before isEmpty()");
        }
        return this.conflicts.isEmpty();
    }

    public String toConflictTree() {
        StringBuffer tree = new StringBuffer();
        for (Conflict c : this.conflicts) {
            this.appendToConflictTree(tree, 1, c);
        }
        return tree.toString();
    }

    private void appendToConflictTree(StringBuffer tree, int indent, Conflict c) {
        for (int i = 0; i < indent; ++i) {
            tree.append(" ");
        }
        tree.append(c.getType()).append(" ").append(c.getQualifiedName());
        tree.append("\n");
        Iterator it = c.getDependants().iterator();
        while (it.hasNext()) {
            this.appendToConflictTree(tree, indent + 1, (Conflict)it.next());
        }
    }

    public String getLastSQLStatement() {
        return this.lastSQLStatement;
    }

    public int getProgress() throws ArchitectException {
        return this.monitorableProgress;
    }

    public Integer getJobSize() throws ArchitectException {
        if (this.doingFindConflicting) {
            if (this.ddlStatements == null) {
                return null;
            }
            return new Integer(this.ddlStatements.size());
        }
        if (this.doingDropConflicting) {
            if (this.conflicts == null) {
                return null;
            }
            return new Integer(this.conflicts.size());
        }
        return null;
    }

    public boolean isFinished() throws ArchitectException {
        if (this.doingDropConflicting || this.doingFindConflicting) {
            return false;
        }
        if (this.dropConflictingStarted) {
            return this.dropConflictingFinished;
        }
        return this.findConflictingFinished;
    }

    public void setCancelled(boolean cancelled) {
        throw new RuntimeException("The Conflict Resolver can't be cancelled");
    }

    public String getMessage() {
        return null;
    }

    public boolean hasStarted() {
        return this.doingDropConflicting || this.doingFindConflicting;
    }

    public class Conflict {
        private String type;
        private String catalog;
        private String schema;
        private String name;
        private List dependants;
        private String sqlDropStatement;

        public Conflict(String type, String catalog, String schema, String name) {
            this.type = type;
            this.catalog = catalog;
            this.schema = schema;
            this.name = name;
            this.dependants = new ArrayList();
        }

        public String getQualifiedName() {
            return DDLUtils.toQualifiedName(this.catalog, this.schema, this.name);
        }

        private void addTableDependants(DatabaseMetaData dbmd) throws SQLException {
            ResultSet ikrs = dbmd.getImportedKeys(this.getCatalog(), this.getSchema(), this.getName());
            this.addDependantsFromKeys(ikrs);
            ikrs.close();
            ikrs = dbmd.getExportedKeys(this.getCatalog(), this.getSchema(), this.getName());
            this.addDependantsFromKeys(ikrs);
            ikrs.close();
        }

        private void addDependantsFromKeys(ResultSet rs) throws SQLException {
            Conflict prev = null;
            while (rs.next()) {
                Conflict c = new Conflict("FOREIGN KEY", rs.getString("FKTABLE_CAT"), rs.getString("FKTABLE_SCHEM"), rs.getString("FK_NAME"));
                if (c.equals(prev)) continue;
                prev = c;
                ConflictResolver.this.ddlg.setTargetCatalog(c.getCatalog());
                ConflictResolver.this.ddlg.setTargetSchema(c.getSchema());
                c.setSqlDropStatement(ConflictResolver.this.ddlg.makeDropForeignKeySQL(rs.getString("FKTABLE_NAME"), c.getName()));
                this.dependants.add(c);
            }
        }

        public String toString() {
            return this.getType() + " " + this.getQualifiedName();
        }

        public void setDependants(List v) {
            this.dependants = v;
        }

        public List getDependants() {
            return this.dependants;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getSqlDropStatement() {
            return this.sqlDropStatement;
        }

        public void setSqlDropStatement(String sqlDropStatement) {
            this.sqlDropStatement = sqlDropStatement;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Conflict)) {
                return false;
            }
            Conflict other = (Conflict)obj;
            return ArchitectUtils.areEqual(this.type, other.type) && ArchitectUtils.areEqual(this.catalog, other.catalog) && ArchitectUtils.areEqual(this.schema, other.schema) && ArchitectUtils.areEqual(this.name, other.name);
        }

        public int hashCode() {
            int hash = 1;
            hash += 31 * hash + (this.type == null ? 0 : this.type.hashCode());
            hash += 31 * hash + (this.catalog == null ? 0 : this.catalog.hashCode());
            hash += 31 * hash + (this.schema == null ? 0 : this.schema.hashCode());
            hash += 31 * hash + (this.name == null ? 0 : this.name.hashCode());
            return hash;
        }
    }
}

