/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLIndex
extends SQLObject {
    private static final Logger logger = Logger.getLogger(SQLIndex.class);
    private SQLTable.Folder<SQLIndex> parent;
    private boolean unique;
    private String qualifier;
    private IndexType type;
    private String filterCondition;
    private boolean primaryKeyIndex;

    public SQLIndex(String name, boolean unique, String qualifier, IndexType type, String filter) {
        this();
        this.setName(name);
        this.unique = unique;
        this.qualifier = qualifier;
        this.type = type;
        this.filterCondition = filter;
    }

    public SQLIndex() {
        this.children = new ArrayList();
        this.primaryKeyIndex = false;
    }

    public SQLIndex(SQLIndex oldIndex) throws ArchitectException {
        this();
        this.setName(oldIndex.getName());
        this.unique = oldIndex.unique;
        this.parent = oldIndex.parent;
        this.populated = oldIndex.populated;
        this.type = oldIndex.type;
        this.filterCondition = oldIndex.filterCondition;
        this.qualifier = oldIndex.qualifier;
        for (Object c : oldIndex.getChildren()) {
            Column oldCol = (Column)c;
            Column newCol = new Column();
            newCol.setAscending(oldCol.ascending);
            newCol.setDescending(oldCol.descending);
            newCol.column = oldCol.column;
            newCol.setName(oldCol.getName());
            this.addChild(newCol);
        }
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return Column.class;
    }

    @Override
    public Column getChild(int index) throws ArchitectException {
        return (Column)super.getChild(index);
    }

    @Override
    public SQLTable.Folder<SQLIndex> getParent() {
        return this.parent;
    }

    public SQLTable getParentTable() {
        SQLObject parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return ((SQLTable.Folder)parent).getParent();
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    protected void populate() throws ArchitectException {
    }

    @Override
    public boolean isPopulated() {
        return true;
    }

    @Override
    protected void setParent(SQLObject parent) {
        this.parent = (SQLTable.Folder)parent;
    }

    @Override
    protected SQLObject removeImpl(int index) {
        Column c = (Column)this.children.get(index);
        if (c.getColumn() != null) {
            c.getColumn().removeSQLObjectListener(c.targetColumnListener);
        }
        return super.removeImpl(index);
    }

    @Override
    protected void addChildImpl(int index, SQLObject newChild) throws ArchitectException {
        if (newChild instanceof Column && this.primaryKeyIndex && ((Column)newChild).getColumn() == null) {
            throw new ArchitectException("Cannot add a \"string\" column to a primary key index");
        }
        super.addChildImpl(index, newChild);
        Column c = (Column)newChild;
        if (c.getColumn() != null) {
            c.getColumn().addSQLObjectListener(c.targetColumnListener);
        }
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        String oldValue = this.filterCondition;
        this.filterCondition = filterCondition;
        this.fireDbObjectChanged("filterCondition", oldValue, filterCondition);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        String oldValue = this.qualifier;
        this.qualifier = qualifier;
        this.fireDbObjectChanged("qualifier", oldValue, qualifier);
    }

    public IndexType getType() {
        return this.type;
    }

    public void setType(IndexType type) {
        IndexType oldValue = this.type;
        this.type = type;
        this.fireDbObjectChanged("type", (Object)oldValue, (Object)type);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        boolean oldValue = this.unique;
        this.unique = unique;
        this.fireDbObjectChanged("unique", oldValue, unique);
    }

    public void setParent(SQLTable.Folder<SQLIndex> parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addIndicesToTable(SQLTable addTo, String catalog, String schema, String tableName) throws SQLException, ArchitectException {
        Connection con = null;
        ResultSet rs = null;
        try {
            con = addTo.getParentDatabase().getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            String pkName = null;
            rs = dbmd.getPrimaryKeys(catalog, schema, tableName);
            while (rs.next()) {
                SQLColumn col = addTo.getColumnByName(rs.getString(4), false, true);
                if (col != null) {
                    col.primaryKeySeq = new Integer(rs.getInt(5));
                    String pkNameCheck = rs.getString(6);
                    if (pkName == null) {
                        pkName = pkNameCheck;
                        continue;
                    }
                    if (pkName.equals(pkNameCheck)) continue;
                    throw new IllegalStateException("The PK name has changed somehow while adding indices to table");
                }
                throw new SQLException("Column " + rs.getString(4) + " not found in " + addTo);
            }
            rs.close();
            rs = null;
            logger.debug((Object)("SQLIndex.addIndicesToTable: catalog=" + catalog + "; schema=" + schema + "; tableName=" + tableName + "; primary key name=" + pkName));
            SQLObject idx = null;
            rs = dbmd.getIndexInfo(catalog, schema, tableName, false, true);
            while (rs.next()) {
                Column col;
                boolean nonUnique = rs.getBoolean(4);
                String qualifier = rs.getString(5);
                String name = rs.getString(6);
                IndexType type = IndexType.forJdbcType(rs.getShort(7));
                int pos = rs.getInt(8);
                String colName = rs.getString(9);
                String ascDesc = rs.getString(10);
                boolean ascending = ascDesc != null && ascDesc.equals("A");
                boolean descending = ascDesc != null && ascDesc.equals("D");
                String filter = rs.getString(13);
                if (pos == 0) continue;
                if (pos == 1) {
                    logger.debug((Object)("Found index " + name));
                    idx = new SQLIndex(name, !nonUnique, qualifier, type, filter);
                    addTo.getIndicesFolder().children.add(idx);
                    if (name.equals(pkName)) {
                        ((SQLIndex)idx).setPrimaryKeyIndex(true);
                    }
                }
                logger.debug((Object)("Adding column " + colName + " to index " + idx.getName()));
                if (addTo.getColumnByName(colName, false, true) != null) {
                    SQLObject sQLObject = idx;
                    sQLObject.getClass();
                    col = (SQLIndex)sQLObject.new Column(addTo.getColumnByName(colName, false, true), ascending, descending);
                } else {
                    SQLObject sQLObject = idx;
                    sQLObject.getClass();
                    col = (SQLIndex)sQLObject.new Column(colName, ascending, descending);
                }
                ((SQLIndex)idx).children.add(col);
            }
            rs.close();
            rs = null;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close result set", (Throwable)ex);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close connection", (Throwable)ex);
            }
        }
    }

    public boolean isPrimaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryKeyIndex(boolean isPrimaryKey) throws ArchitectException {
        boolean oldValue = this.primaryKeyIndex;
        if (oldValue == isPrimaryKey) {
            return;
        }
        try {
            this.startCompoundEdit("Make index a Primary Key");
            if (isPrimaryKey) {
                SQLIndex i;
                for (Column c : this.getChildren()) {
                    if (c.getColumn() != null) continue;
                    throw new ArchitectException("A PK must only refer to Index.Columns that contain SQLColumns");
                }
                SQLTable parentTable = this.getParentTable();
                if (parentTable != null && (i = parentTable.getPrimaryKeyIndex()) != null && i != this) {
                    i.setPrimaryKeyIndex(false);
                }
            }
            this.primaryKeyIndex = isPrimaryKey;
            this.fireDbObjectChanged("primaryKeyIndex", oldValue, isPrimaryKey);
        }
        finally {
            this.endCompoundEdit("Make index a Primary Key");
        }
    }

    public String toString() {
        return this.getName();
    }

    public void addIndexColumn(SQLColumn col1, boolean ascending, boolean descending) throws ArchitectException {
        Column col = new Column(col1, ascending, descending);
        this.addChild(col);
    }

    public static SQLIndex getDerivedInstance(SQLIndex source, SQLTable parenTable) throws ArchitectException {
        SQLIndex index = new SQLIndex();
        index.setName(source.getName());
        index.setUnique(source.isUnique());
        index.setPopulated(source.isPopulated());
        index.setType(source.getType());
        index.setFilterCondition(source.getFilterCondition());
        index.setQualifier(source.getQualifier());
        index.setPrimaryKeyIndex(source.isPrimaryKeyIndex());
        for (Column column : source.getChildren()) {
            SQLColumn sqlColumn = parenTable.getColumnByName(column.getColumn().getName());
            if (sqlColumn == null) {
                throw new ArchitectException("Can not derive instance, because coulmn " + column.getColumn().getName() + "is not found in parent table [" + parenTable.getName() + "]");
            }
            SQLIndex sQLIndex = index;
            sQLIndex.getClass();
            Column newColumn = sQLIndex.new Column(sqlColumn, column.isAscending(), column.isDescending());
            index.addChild(newColumn);
        }
        return index;
    }

    public void makeColumnsLike(SQLIndex index) throws ArchitectException {
        List columns = index.getChildren();
        for (int i = this.children.size() - 1; i >= 0; --i) {
            Column c = (Column)this.children.get(i);
            if (c.column != null) {
                c.column.removeSQLObjectListener(c.targetColumnListener);
            }
            this.removeChild(i);
        }
        for (Object o : columns) {
            Column c = (Column)o;
            Column newCol = new Column(c.getName(), c.isAscending(), c.isDescending());
            newCol.setColumn(c.getColumn());
            this.addChild(newCol);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Column
    extends SQLObject {
        private SQLColumn column;
        private boolean ascending;
        private boolean descending;
        private final TargetColumnListener targetColumnListener = new TargetColumnListener();

        public Column(SQLColumn col, boolean ascending, boolean descending) {
            this(col.getName(), ascending, descending);
            this.setColumn(col);
        }

        public Column(String name, boolean ascending, boolean descending) {
            this.children = Collections.emptyList();
            this.setName(name);
            this.ascending = ascending;
            this.descending = descending;
        }

        public Column() {
            this((String)null, false, false);
        }

        @Override
        public boolean allowsChildren() {
            return false;
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return null;
        }

        @Override
        public SQLObject getParent() {
            return SQLIndex.this;
        }

        @Override
        public String getShortDisplayName() {
            return this.getName();
        }

        @Override
        protected void populate() throws ArchitectException {
        }

        @Override
        public boolean isPopulated() {
            return true;
        }

        @Override
        protected void setParent(SQLObject parent) {
            if (parent != null && parent != SQLIndex.this) {
                throw new UnsupportedOperationException("You can't change an Index.Column's parent");
            }
        }

        public SQLColumn getColumn() {
            return this.column;
        }

        public void setColumn(SQLColumn column) {
            if (this.column != null) {
                this.column.removeSQLObjectListener(this.targetColumnListener);
            }
            SQLColumn oldValue = this.column;
            this.column = column;
            if (this.column != null) {
                this.column.addSQLObjectListener(this.targetColumnListener);
            }
            this.fireDbObjectChanged("column", oldValue, column);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            boolean oldValue = this.ascending;
            this.ascending = ascending;
            this.fireDbObjectChanged("ascending", oldValue, ascending);
        }

        public boolean isDescending() {
            return this.descending;
        }

        public void setDescending(boolean descending) {
            boolean oldValue = this.descending;
            this.descending = descending;
            this.fireDbObjectChanged("descending", oldValue, descending);
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.ascending ? 1231 : 1237);
            result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
            result = 31 * result + (this.descending ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Column other = (Column)obj;
            if (this.ascending != other.ascending) {
                return false;
            }
            if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
                return false;
            }
            return this.descending == other.descending;
        }

        private class TargetColumnListener
        implements SQLObjectListener {
            private TargetColumnListener() {
            }

            public void dbChildrenInserted(SQLObjectEvent e) {
            }

            public void dbChildrenRemoved(SQLObjectEvent e) {
            }

            public void dbObjectChanged(SQLObjectEvent e) {
                if ("name".equals(e.getPropertyName())) {
                    Column.this.setName((String)e.getNewValue());
                }
            }

            public void dbStructureChanged(SQLObjectEvent e) {
                Column.this.fireDbStructureChanged();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append(SQLIndex.this.getName());
                buf.append(".");
                buf.append(Column.this.getName());
                buf.append(".");
                buf.append("TargetColumnListener");
                buf.append(" isPrimarykey?");
                buf.append(SQLIndex.this.primaryKeyIndex);
                return buf.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        STATISTIC(0),
        CLUSTERED(1),
        HASHED(2),
        OTHER(3);

        private short jdbcType;

        private IndexType(short jdbcType) {
            this.jdbcType = jdbcType;
        }

        public short getJdbcType() {
            return this.jdbcType;
        }

        public static IndexType forJdbcType(short jdbcType) {
            if (jdbcType == 0) {
                return STATISTIC;
            }
            if (jdbcType == 1) {
                return CLUSTERED;
            }
            if (jdbcType == 2) {
                return HASHED;
            }
            if (jdbcType == 3) {
                return OTHER;
            }
            throw new IllegalArgumentException("Unknown JDBC index type code: " + jdbcType);
        }
    }
}

