/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnectionSpec;
import ca.sqlpower.sql.DBConnectionSpecServer;
import ca.sqlpower.sql.XMLFileDBCSSource;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DBConnectionSpecServerImpl
extends UnicastRemoteObject
implements DBConnectionSpecServer {
    Object fileLock = null;
    protected String xmlFileName = null;

    public Collection getAvailableDatabases() throws RemoteException {
        LinkedList databases = null;
        try {
            XMLFileDBCSSource xmlSource = new XMLFileDBCSSource(this.xmlFileName);
            databases = new LinkedList(xmlSource.getDBCSList());
            Collections.sort(databases);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException("Could not read XML File (see RMI server log)", e);
        }
        return databases;
    }

    public static void main(String[] args) throws RemoteException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        DBConnectionSpecServerImpl obj = new DBConnectionSpecServerImpl();
        obj.xmlFileName = System.getProperty("databasesFile");
        if (obj.xmlFileName == null) {
            System.out.println("no databases file specified.  Please add -DdatabaseFile=filename to the command line.");
        } else {
            try {
                LocateRegistry.createRegistry(1099);
                Naming.rebind("///DBConnectionSpecServer", obj);
                System.out.println("DBConnectionSpecServer bound in registry");
            }
            catch (Exception e) {
                System.out.println("DBConnectionSpecImpl err: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void setAvailableDatabases(Collection dbList, String oldPass, String newPass) throws RemoteException {
        try {
            this.writeDBSpecsToOutputStream(dbList, oldPass, newPass);
        }
        catch (Exception e) {
            throw new RemoteException("could not set databases", e);
        }
    }

    public boolean checkPassword(String argPassword) throws RemoteException {
        try {
            FileInputStream xmlStream = new FileInputStream(this.xmlFileName);
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document d = db.parse(xmlStream);
            NodeList list = d.getElementsByTagName("databases");
            Element e = (Element)list.item(0);
            String password = e.getAttribute("password");
            return argPassword.equals(password);
        }
        catch (Exception e) {
            throw new RemoteException("could not check password", e);
        }
    }

    protected synchronized void writeDBSpecsToOutputStream(Collection dbspecs, String oldPassword, String newPassword) throws ParserConfigurationException, IOException {
        if (!this.checkPassword(oldPassword)) {
            return;
        }
        FileOutputStream xmlStream = new FileOutputStream(this.xmlFileName);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = db.newDocument();
        Element databases = d.createElement("databases");
        if (newPassword != null) {
            databases.setAttribute("password", newPassword);
        } else {
            databases.setAttribute("password", oldPassword);
        }
        for (DBConnectionSpec dbcs : dbspecs) {
            Element dbNode = d.createElement("database");
            dbNode.setAttribute("name", dbcs.getName());
            dbNode.setAttribute("seqNo", Integer.toString(dbcs.getSeqNo()));
            dbNode.setAttribute("singleLogin", dbcs.isSingleLogin() ? "true" : "false");
            if (dbcs.getDisplayName() != null) {
                Element displayName = d.createElement("display-name");
                displayName.appendChild(d.createTextNode(dbcs.getDisplayName()));
                dbNode.appendChild(displayName);
            }
            if (dbcs.getDriverClass() != null) {
                Element driverClass = d.createElement("driver-class");
                driverClass.appendChild(d.createTextNode(dbcs.getDriverClass()));
                dbNode.appendChild(driverClass);
            }
            if (dbcs.getUrl() != null) {
                Element url = d.createElement("url");
                url.appendChild(d.createTextNode(dbcs.getUrl()));
                dbNode.appendChild(url);
            }
            if (dbcs.getUser() != null) {
                Element user = d.createElement("user");
                user.appendChild(d.createTextNode(dbcs.getUser()));
                dbNode.appendChild(user);
            }
            if (dbcs.getPass() != null) {
                Element pass = d.createElement("pass");
                pass.appendChild(d.createTextNode(dbcs.getPass()));
                dbNode.appendChild(pass);
            }
            databases.appendChild(dbNode);
        }
        d.appendChild(databases);
        OutputFormat of = new OutputFormat();
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer((OutputStream)xmlStream, of);
        serializer.serialize(d);
        ((OutputStream)xmlStream).close();
    }
}

