/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoManager;
import java.awt.Point;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import junit.framework.TestCase;

public class TestSQLObjectUndoableEventAdapter
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMove() throws ArchitectException {
        PlayPen pp = new PlayPen(new SQLDatabase());
        SQLTable table = new SQLTable(pp.getDatabase(), true);
        TablePane tp = new TablePane(table, pp);
        pp.addTablePane(tp, new Point());
        UndoManager undoManager = new UndoManager(pp);
        Point location = tp.getLocation();
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved to the right location", (boolean)location.equals(tp.getLocation()));
        Point newLocation = location.getLocation();
        ++newLocation.x;
        ++newLocation.y;
        tp.setLocation(newLocation);
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved to the right location", (boolean)newLocation.equals(tp.getLocation()));
        undoManager.undo();
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved to the right location", (boolean)location.equals(tp.getLocation()));
        undoManager.redo();
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved to the right location", (boolean)newLocation.equals(tp.getLocation()));
    }

    public void testMultiMove() throws ArchitectException {
        SQLDatabase db = new SQLDatabase();
        PlayPen pp = new PlayPen(db);
        SQLTable table = new SQLTable(db, true);
        TablePane tp = new TablePane(table, pp);
        SQLTable table2 = new SQLTable(db, true);
        TablePane tp2 = new TablePane(table2, pp);
        pp.addTablePane(tp, new Point());
        Point location = tp.getLocation();
        pp.addTablePane(tp2, new Point());
        Point location2 = tp2.getLocation();
        UndoManager undoManager = new UndoManager(pp);
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved to the right location", (boolean)location2.equals(tp2.getLocation()));
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved to the right location", (boolean)location.equals(tp.getLocation()));
        Point newLocation = location.getLocation();
        ++newLocation.x;
        ++newLocation.y;
        Point newLocation2 = location2.getLocation();
        newLocation2.x += 2;
        newLocation2.y += 2;
        pp.startCompoundEdit("Starting move");
        tp.setLocation(newLocation);
        tp2.setLocation(newLocation2);
        pp.endCompoundEdit("Ending move");
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved 1 to the right location", (boolean)newLocation.equals(tp.getLocation()));
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved 2 to the right location", (boolean)newLocation2.equals(tp2.getLocation()));
        undoManager.undo();
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved 1 to the right location", (boolean)location.equals(tp.getLocation()));
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved 2 to the right location", (boolean)location2.equals(tp2.getLocation()));
        undoManager.redo();
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved 1 to the right location", (boolean)newLocation.equals(tp.getLocation()));
        TestSQLObjectUndoableEventAdapter.assertTrue((String)"Moved 2 to the right location", (boolean)newLocation2.equals(tp2.getLocation()));
    }

    public void testCompoundEditEvent() throws ArchitectException {
        SQLDatabase db = new SQLDatabase();
        PlayPen pp = new PlayPen(db);
        UndoManager manager = new UndoManager(pp);
        StateChangeTestListner listner = new StateChangeTestListner();
        manager.addChangeListener(listner);
        UndoManager.SQLObjectUndoableEventAdapter adapter = manager.getEventAdapter();
        TestSQLObjectUndoableEventAdapter.assertTrue((boolean)adapter.canUndoOrRedo());
        adapter.compoundEditStart(new UndoCompoundEvent((Object)new SQLTable(), UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, "Test"));
        TestSQLObjectUndoableEventAdapter.assertEquals((String)" Improper number of state changes after first compound edit", (int)1, (int)listner.stateChanges);
        TestSQLObjectUndoableEventAdapter.assertFalse((boolean)adapter.canUndoOrRedo());
        adapter.compoundEditEnd(new UndoCompoundEvent((Object)new SQLTable(), UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, "Test"));
        TestSQLObjectUndoableEventAdapter.assertEquals((String)" Improper number of state changes after first compound edit", (int)2, (int)listner.stateChanges);
        TestSQLObjectUndoableEventAdapter.assertTrue((boolean)adapter.canUndoOrRedo());
    }

    private final class StateChangeTestListner
    implements ChangeListener {
        public int stateChanges;

        private StateChangeTestListner() {
        }

        public void stateChanged(ChangeEvent e) {
            ++this.stateChanges;
        }
    }
}

