/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class SQLObjectChildren
extends AbstractUndoableEdit {
    protected SQLObjectEvent e;
    protected String toolTip;

    public void createEditFromEvent(SQLObjectEvent event) {
        this.e = event;
        this.createToolTip();
    }

    public abstract void createToolTip();

    public void removeChildren() {
        int[] changed = this.e.getChangedIndices();
        SQLObject sqlObject = this.e.getSQLSource();
        SQLObject parent = sqlObject.getParent();
        try {
            if (parent != null) {
                parent.setMagicEnabled(false);
            }
            sqlObject.setMagicEnabled(false);
            int ii = 0;
            while (ii < changed.length) {
                sqlObject.removeChild(changed[ii]);
                ++ii;
            }
        }
        finally {
            sqlObject.setMagicEnabled(true);
            if (parent != null) {
                parent.setMagicEnabled(true);
            }
        }
    }

    public void addChildren() throws ArchitectException {
        int[] changed = this.e.getChangedIndices();
        SQLObject sqlObject = this.e.getSQLSource();
        SQLObject[] children = this.e.getChildren();
        SQLObject parent = sqlObject.getParent();
        try {
            if (parent != null) {
                parent.setMagicEnabled(false);
            }
            sqlObject.setMagicEnabled(false);
            int ii = 0;
            while (ii < changed.length) {
                sqlObject.addChild(changed[ii], children[ii]);
                ++ii;
            }
        }
        finally {
            if (parent != null) {
                parent.setMagicEnabled(true);
            }
            sqlObject.setMagicEnabled(true);
        }
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.toolTip;
    }
}

