/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.swingui.table.TableUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelColumnAutofit
extends AbstractTableModel {
    private TableModel tableModel;
    private MouseListener mouseListener;
    private JTable table;
    private JTableHeader tableHeader;

    public TableModelColumnAutofit(TableModel tableModel, JTable table) {
        this.tableModel = tableModel;
        this.table = table;
        this.tableHeader = table.getTableHeader();
        this.mouseListener = new MouseListener();
    }

    @Override
    public int getRowCount() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getRowCount();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getColumnName(column);
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        this.tableHeader.removeMouseListener(this.mouseListener);
        this.tableHeader = tableHeader;
        this.tableHeader.addMouseListener(this.mouseListener);
    }

    public void initColumnSizes() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.initSingleColumnSize(i);
            ++i;
        }
    }

    public void initSingleColumnSize(int colIndex) {
        TableUtils.fitColumnWidth(this.table, colIndex, 0);
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            if (e.isControlDown()) {
                TableModelColumnAutofit.this.initSingleColumnSize(viewColumn);
            }
        }
    }
}

