/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.EditColumnAction;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import java.awt.Point;
import junit.framework.TestCase;

public class TestEditColumnAction
extends TestCase {
    private EditColumnAction editColumn;
    private PlayPen pp;
    private TablePane tp;
    private Relationship r;
    private TablePane tp2;

    protected void setUp() throws Exception {
        super.setUp();
        this.editColumn = new EditColumnAction();
        this.pp = new PlayPen();
        this.editColumn.setPlayPen(this.pp);
        this.tp = new TablePane(new SQLTable(this.pp.getDatabase(), true), this.pp);
        this.tp.getModel().setName("Table1");
        this.tp.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col1", 4, 1, 1));
        this.tp.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col2", 4, 1, 1));
        this.tp2 = new TablePane(new SQLTable(this.pp.getDatabase(), true), this.pp);
        this.tp2.getModel().setName("Table2");
        this.tp2.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col1", 4, 1, 1));
        this.tp2.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col2", 4, 1, 1));
        SQLRelationship sqlRelationship = new SQLRelationship();
        this.pp.addTablePane(this.tp, new Point());
        this.pp.addTablePane(this.tp2, new Point());
        sqlRelationship.attachRelationship(this.tp.getModel(), this.tp.getModel(), false);
        this.r = new Relationship(this.pp, sqlRelationship);
        this.pp.addRelationship(this.r);
    }

    public void testTableSelected() throws ArchitectException {
        TestEditColumnAction.assertFalse((String)"Action enabled with no items", (boolean)this.editColumn.isEnabled());
        this.tp.setSelected(true);
        this.editColumn.itemSelected(new SelectionEvent(this.tp, 1));
        TestEditColumnAction.assertFalse((String)"Action should be not enabled", (boolean)this.editColumn.isEnabled());
    }

    public void testRelationshipSelected() {
        TestEditColumnAction.assertFalse((String)"Action enabled with no items", (boolean)this.editColumn.isEnabled());
        this.r.setSelected(true);
        this.editColumn.itemSelected(new SelectionEvent(this.r, 1));
        TestEditColumnAction.assertFalse((String)"Action should be disabled", (boolean)this.editColumn.isEnabled());
    }

    public void testTableAndRelationshipSelected() {
        TestEditColumnAction.assertFalse((String)"Action enabled with no items", (boolean)this.editColumn.isEnabled());
        this.r.setSelected(true);
        this.editColumn.itemSelected(new SelectionEvent(this.r, 1));
        this.tp.setSelected(true);
        this.editColumn.itemSelected(new SelectionEvent(this.tp, 1));
        TestEditColumnAction.assertFalse((String)"Action should be disabled", (boolean)this.editColumn.isEnabled());
        this.r.setSelected(false);
        this.editColumn.itemSelected(new SelectionEvent(this.r, 2));
        TestEditColumnAction.assertFalse((String)"Action should still be disabled", (boolean)this.editColumn.isEnabled());
        this.tp.setSelected(false);
    }

    public void testColumnSelected() throws ArchitectException {
        TestEditColumnAction.assertFalse((String)"Action enabled with no items", (boolean)this.editColumn.isEnabled());
        this.tp.setSelected(true);
        this.tp.selectColumn(0);
        this.editColumn.itemSelected(new SelectionEvent(this.tp, 1));
        TestEditColumnAction.assertEquals((Object)"Editting col1", (Object)this.editColumn.getValue("ShortDescription"));
        this.tp.selectColumn(1);
        this.editColumn.itemSelected(new SelectionEvent(this.tp, 1));
        TestEditColumnAction.assertTrue((String)"Action not enabled", (boolean)this.editColumn.isEnabled());
        this.tp.selectNone();
        this.editColumn.itemSelected(new SelectionEvent(this.tp, 2));
        TestEditColumnAction.assertFalse((String)"No column is selected, only tables, should disable", (boolean)this.editColumn.isEnabled());
    }

    public void testTableAndColumnSelected() {
        TestEditColumnAction.assertFalse((String)"Action enabled with no items", (boolean)this.editColumn.isEnabled());
        this.tp.setSelected(true);
        this.tp.selectColumn(0);
        this.editColumn.itemSelected(new SelectionEvent(this.tp, 1));
        this.tp2.setSelected(true);
        this.editColumn.itemSelected(new SelectionEvent(this.tp2, 1));
        TestEditColumnAction.assertFalse((String)"Action not enabled", (boolean)this.editColumn.isEnabled());
        this.tp2.setSelected(false);
        this.editColumn.itemSelected(new SelectionEvent(this.tp2, 2));
        TestEditColumnAction.assertTrue((String)"Action not enabled", (boolean)this.editColumn.isEnabled());
        this.tp.selectNone();
        this.editColumn.itemSelected(new SelectionEvent(this.tp, 2));
        TestEditColumnAction.assertFalse((String)"Only table is selected, should disable", (boolean)this.editColumn.isEnabled());
    }
}

