/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.DeleteSelectedAction;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import java.awt.Point;
import junit.framework.TestCase;

public class TestDeleteSelectedAction
extends TestCase {
    private DeleteSelectedAction deleteAction;
    private PlayPen pp;
    private TablePane tp;
    private Relationship r;
    private TablePane tp2;

    protected void setUp() throws Exception {
        super.setUp();
        this.deleteAction = new DeleteSelectedAction();
        this.pp = new PlayPen();
        this.deleteAction.setPlayPen(this.pp);
        this.tp = new TablePane(new SQLTable(this.pp.getDatabase(), true), this.pp);
        this.tp.getModel().setName("Table1");
        this.tp.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col1", 4, 1, 1));
        this.tp.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col2", 4, 1, 1));
        this.tp2 = new TablePane(new SQLTable(this.pp.getDatabase(), true), this.pp);
        this.tp2.getModel().setName("Table2");
        this.tp2.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col1", 4, 1, 1));
        this.tp2.getModel().addColumn(new SQLColumn(this.tp.getModel(), "col2", 4, 1, 1));
        SQLRelationship sqlRelationship = new SQLRelationship();
        this.pp.addTablePane(this.tp, new Point());
        this.pp.addTablePane(this.tp2, new Point());
        sqlRelationship.attachRelationship(this.tp.getModel(), this.tp.getModel(), false);
        this.r = new Relationship(this.pp, sqlRelationship);
        this.pp.addRelationship(this.r);
    }

    public void testTableSelected() throws ArchitectException {
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
        this.tp.setSelected(true);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 1));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled", (boolean)this.deleteAction.isEnabled());
        TestDeleteSelectedAction.assertEquals((String)"Incorrect Tooltip", (Object)"Delete Table1", (Object)this.deleteAction.getValue("ShortDescription"));
        this.tp.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 2));
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
    }

    public void testRelationshipSelected() {
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
        this.r.setSelected(true);
        this.deleteAction.itemSelected(new SelectionEvent(this.r, 1));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled", (boolean)this.deleteAction.isEnabled());
        this.r.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.r, 2));
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
    }

    public void testTableAndRelationshipSelected() {
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
        this.r.setSelected(true);
        this.deleteAction.itemSelected(new SelectionEvent(this.r, 1));
        this.tp.setSelected(true);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 1));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled", (boolean)this.deleteAction.isEnabled());
        TestDeleteSelectedAction.assertEquals((Object)"Delete 2 items", (Object)this.deleteAction.getValue("ShortDescription"));
        this.r.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.r, 2));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled when we still have an enabled component", (boolean)this.deleteAction.isEnabled());
        this.tp.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 2));
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
    }

    public void testColumnSelected() throws ArchitectException {
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
        this.tp.setSelected(true);
        this.tp.selectColumn(0);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 1));
        TestDeleteSelectedAction.assertEquals((Object)"Delete col1", (Object)this.deleteAction.getValue("ShortDescription"));
        this.tp.selectColumn(1);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 1));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled", (boolean)this.deleteAction.isEnabled());
        TestDeleteSelectedAction.assertEquals((String)"tooltip incorrect for two selected columns", (Object)"Delete 2 items", (Object)this.deleteAction.getValue("ShortDescription"));
        this.tp.selectNone();
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 2));
        TestDeleteSelectedAction.assertTrue((String)"Action not enable when columns unselected, but table selected", (boolean)this.deleteAction.isEnabled());
    }

    public void testTableAndColumnSelected() {
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
        this.tp.setSelected(true);
        this.tp.selectColumn(0);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 1));
        this.tp2.setSelected(true);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp2, 1));
        TestDeleteSelectedAction.assertEquals((Object)"Delete 2 items", (Object)this.deleteAction.getValue("ShortDescription"));
        this.tp2.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp2, 2));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled", (boolean)this.deleteAction.isEnabled());
        TestDeleteSelectedAction.assertEquals((String)"tooltip incorrect for two selected columns", (Object)"Delete col1", (Object)this.deleteAction.getValue("ShortDescription"));
        this.tp.selectNone();
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 2));
        TestDeleteSelectedAction.assertTrue((String)"Action not enable when columns unselected, but table selected", (boolean)this.deleteAction.isEnabled());
    }

    public void testTableAndRelationshipAndColumnSelected() {
        TestDeleteSelectedAction.assertFalse((String)"Action enabled with no items", (boolean)this.deleteAction.isEnabled());
        this.r.setSelected(true);
        this.deleteAction.itemSelected(new SelectionEvent(this.r, 1));
        this.tp.setSelected(true);
        this.tp.selectColumn(0);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 1));
        this.tp2.setSelected(true);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp2, 1));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled", (boolean)this.deleteAction.isEnabled());
        TestDeleteSelectedAction.assertEquals((Object)"Delete 3 items", (Object)this.deleteAction.getValue("ShortDescription"));
        this.r.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.r, 2));
        this.tp.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 2));
        TestDeleteSelectedAction.assertTrue((String)"Action not enabled when we still have an enabled component", (boolean)this.deleteAction.isEnabled());
        TestDeleteSelectedAction.assertEquals((Object)"Delete Table2", (Object)this.deleteAction.getValue("ShortDescription"));
        this.tp2.setSelected(false);
        this.deleteAction.itemSelected(new SelectionEvent(this.tp, 2));
        TestDeleteSelectedAction.assertFalse((String)"Nothing is selected", (boolean)this.deleteAction.isEnabled());
    }
}

