/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.CreateRelationshipAction;
import java.awt.Point;
import java.util.List;
import junit.framework.TestCase;

public class TestCreateRelationshipAction
extends TestCase {
    PlayPen pp;
    SQLTable fkTable;
    SQLTable pkTable;

    protected void setUp() throws Exception {
        super.setUp();
        SQLDatabase db = new SQLDatabase();
        this.pp = new PlayPen();
        this.fkTable = new SQLTable(db, true);
        TablePane tp = new TablePane(this.fkTable, this.pp);
        this.pp.addTablePane(tp, new Point(1, 1));
        this.pkTable = new SQLTable(db, true);
        TablePane tp2 = new TablePane(this.pkTable, this.pp);
        this.pp.addTablePane(tp2, new Point(1, 1));
        this.pkTable.addColumn(new SQLColumn());
        this.pkTable.addColumn(new SQLColumn());
        this.pkTable.getColumn(0).setPrimaryKeySeq(1);
        this.pkTable.getColumn(0).setName("pk1");
        this.pkTable.getColumn(1).setPrimaryKeySeq(1);
        this.pkTable.getColumn(1).setName("pk2");
    }

    public void testDoCreateRelationshipIdentifying() throws ArchitectException {
        TestCreateRelationshipAction.assertEquals((String)"Oops started out with relationships", (int)0, (int)this.pp.getRelationships().size());
        CreateRelationshipAction.doCreateRelationship(this.pkTable, this.fkTable, this.pp, true);
        TestCreateRelationshipAction.assertEquals((String)"Wrong number of relationships created", (int)1, (int)this.pp.getRelationships().size());
        TestCreateRelationshipAction.assertEquals((String)"Did the relationship create the columns in the fkTable", (int)2, (int)this.fkTable.getColumns().size());
        List<SQLColumn> columns = this.fkTable.getColumns();
        TestCreateRelationshipAction.assertNotNull((String)"Is the first column a key column?", (Object)columns.get(0).getPrimaryKeySeq());
        TestCreateRelationshipAction.assertNotNull((String)"Is the second column a key column?", (Object)columns.get(1).getPrimaryKeySeq());
        TestCreateRelationshipAction.assertEquals((String)"Is the first column pk1?", (String)"pk1", (String)columns.get(0).getName());
        TestCreateRelationshipAction.assertEquals((String)"Is the second column pk2?", (String)"pk2", (String)columns.get(1).getName());
    }

    public void testDoCreateRelationshipNonIdentifying() throws ArchitectException {
        TestCreateRelationshipAction.assertEquals((String)"Oops started out with relationships", (int)0, (int)this.pp.getRelationships().size());
        CreateRelationshipAction.doCreateRelationship(this.pkTable, this.fkTable, this.pp, false);
        TestCreateRelationshipAction.assertEquals((String)"Wrong number of relationships created", (int)1, (int)this.pp.getRelationships().size());
        TestCreateRelationshipAction.assertEquals((String)"Did the relationship create the columns in the fkTable", (int)2, (int)this.fkTable.getColumns().size());
        List<SQLColumn> columns = this.fkTable.getColumns();
        TestCreateRelationshipAction.assertNull((String)"Is the first column a key column?", (Object)columns.get(0).getPrimaryKeySeq());
        TestCreateRelationshipAction.assertNull((String)"Is the second column a key column?", (Object)columns.get(1).getPrimaryKeySeq());
        TestCreateRelationshipAction.assertEquals((String)"Is the first column pk1?", (String)"pk1", (String)columns.get(0).getName());
        TestCreateRelationshipAction.assertEquals((String)"Is the second column pk2?", (String)"pk2", (String)columns.get(1).getName());
    }

    public void testDoCreateRelationshipHicjackColumn() throws ArchitectException {
        this.fkTable.addColumn(new SQLColumn());
        this.fkTable.getColumn(0).setName("pk1");
        TestCreateRelationshipAction.assertEquals((String)"Oops started out with relationships", (int)0, (int)this.pp.getRelationships().size());
        CreateRelationshipAction.doCreateRelationship(this.pkTable, this.fkTable, this.pp, true);
        TestCreateRelationshipAction.assertEquals((String)"Wrong number of relationships created", (int)1, (int)this.pp.getRelationships().size());
        TestCreateRelationshipAction.assertEquals((String)"Did the relationship create the columns in the fkTable", (int)2, (int)this.fkTable.getColumns().size());
        List<SQLColumn> columns = this.fkTable.getColumns();
        TestCreateRelationshipAction.assertEquals((String)"Do we only have two columns in the fk table", (int)2, (int)columns.size());
        TestCreateRelationshipAction.assertNotNull((String)"Is the first column a key column?", (Object)columns.get(0).getPrimaryKeySeq());
        TestCreateRelationshipAction.assertNotNull((String)"Is the second column a key column?", (Object)columns.get(1).getPrimaryKeySeq());
        TestCreateRelationshipAction.assertEquals((String)"Is the first column pk1?", (String)"pk1", (String)columns.get(0).getName());
        TestCreateRelationshipAction.assertEquals((String)"Is the second column pk2?", (String)"pk2", (String)columns.get(1).getName());
    }
}

