/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileCSVFormat;
import ca.sqlpower.architect.profile.ProfileFormat;
import ca.sqlpower.architect.profile.ProfileHTMLFormat;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfilePDFFormat;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.table.ProfileTable;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SaveProfileAction
extends AbstractAction {
    private JDialog parent;
    private ProfileTable viewTable;
    private ProfileManager pm;

    public SaveProfileAction(JDialog parent, ProfileTable viewTable, ProfileManager pm) {
        super("Save");
        this.parent = parent;
        this.viewTable = viewTable;
        this.pm = pm;
    }

    public void actionPerformed(ActionEvent e) {
        SaveableFileType type;
        int response;
        final ArrayList<ProfileResult> objectToSave = new ArrayList<ProfileResult>();
        if (this.viewTable.getSelectedRowCount() > 1) {
            int[] selectedRows = this.viewTable.getSelectedRows();
            HashSet<SQLTable> selectedTable = new HashSet<SQLTable>();
            HashSet<SQLColumn> selectedColumn = new HashSet<SQLColumn>();
            int i = 0;
            while (i < selectedRows.length) {
                int rowid = selectedRows[i];
                ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(rowid);
                selectedTable.add(((SQLColumn)result.getProfiledObject()).getParentTable());
                selectedColumn.add((SQLColumn)result.getProfiledObject());
                ++i;
            }
            boolean fullSelection = true;
            block7: for (SQLTable t : selectedTable) {
                try {
                    for (SQLColumn c : t.getColumns()) {
                        if (selectedColumn.contains(c)) continue;
                        fullSelection = false;
                        continue block7;
                    }
                }
                catch (ArchitectException e1) {
                    ASUtils.showExceptionDialog(this.parent, "Could not get column from table", e1, new ArchitectExceptionReportFactory());
                }
            }
            int response2 = 0;
            if (!fullSelection) {
                response2 = JOptionPane.showConfirmDialog(this.parent, "You have selected partical table, Do you want to save only this portion? No to save the whole table", "Your selection contains partical table(s)", 0);
            }
            if (response2 == 1) {
                for (SQLTable t : selectedTable) {
                    objectToSave.add(this.pm.getResult(t));
                    try {
                        for (SQLColumn c : t.getColumns()) {
                            objectToSave.add(this.pm.getResult(c));
                        }
                    }
                    catch (ArchitectException e1) {
                        ASUtils.showExceptionDialog(this.parent, "Could not get column from table", e1, new ArchitectExceptionReportFactory());
                    }
                }
            } else {
                int i2 = 0;
                while (i2 < selectedRows.length) {
                    int rowid = selectedRows[i2];
                    ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(rowid);
                    SQLColumn column = (SQLColumn)result.getProfiledObject();
                    SQLTable table = column.getParentTable();
                    TableProfileResult tpr = (TableProfileResult)this.pm.getResult(table);
                    if (!objectToSave.contains(tpr)) {
                        objectToSave.add(tpr);
                    }
                    objectToSave.add(result);
                    ++i2;
                }
            }
        } else {
            int i = 0;
            while (i < this.viewTable.getRowCount()) {
                ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(i);
                SQLColumn column = (SQLColumn)result.getProfiledObject();
                SQLTable table = column.getParentTable();
                TableProfileResult tpr = (TableProfileResult)this.pm.getResult(table);
                if (!objectToSave.contains(tpr)) {
                    objectToSave.add(tpr);
                }
                objectToSave.add(result);
                ++i;
            }
        }
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(ASUtils.HTML_FILE_FILTER);
        chooser.addChoosableFileFilter(ASUtils.PDF_FILE_FILTER);
        chooser.addChoosableFileFilter(ASUtils.CSV_FILE_FILTER);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        File file = null;
        do {
            if ((response = chooser.showSaveDialog(this.parent)) != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            FileFilter fileFilter = chooser.getFileFilter();
            String fileName = file.getName();
            int x = fileName.lastIndexOf(46);
            boolean gotType = false;
            SaveableFileType ntype = null;
            if (x != -1) {
                String ext = fileName.substring(x + 1);
                try {
                    ntype = SaveableFileType.valueOf(ext.toUpperCase());
                    gotType = true;
                }
                catch (IllegalArgumentException iex) {
                    gotType = false;
                }
            }
            if (gotType) {
                type = ntype;
                continue;
            }
            if (fileFilter == ASUtils.HTML_FILE_FILTER) {
                if (!fileName.endsWith(".html")) {
                    file = new File(String.valueOf(file.getPath()) + ".html");
                }
                type = SaveableFileType.HTML;
                continue;
            }
            if (fileFilter == ASUtils.PDF_FILE_FILTER) {
                if (!fileName.endsWith(".pdf")) {
                    file = new File(String.valueOf(file.getPath()) + ".pdf");
                }
                type = SaveableFileType.PDF;
                continue;
            }
            if (fileFilter == ASUtils.CSV_FILE_FILTER) {
                if (!fileName.endsWith(".csv")) {
                    file = new File(String.valueOf(file.getPath()) + ".csv");
                }
                type = SaveableFileType.CSV;
                continue;
            }
            throw new IllegalStateException("Unexpected file filter chosen");
        } while (file.exists() && (response = JOptionPane.showConfirmDialog(this.parent, "The file\n" + file.getPath() + "\nalready exists. Do you want to overwrite it?", "File Exists", 0)) == 1);
        final File file2 = new File(file.getPath());
        final SaveableFileType type2 = type;
        Runnable saveTask = new Runnable(){

            public void run() {
                OutputStream out = null;
                try {
                    try {
                        ProfileFormat prf = null;
                        out = new BufferedOutputStream(new FileOutputStream(file2));
                        switch (type2) {
                            case HTML: {
                                String encoding = "utf-8";
                                prf = new ProfileHTMLFormat("utf-8");
                                break;
                            }
                            case PDF: {
                                prf = new ProfilePDFFormat();
                                break;
                            }
                            case CSV: {
                                prf = new ProfileCSVFormat();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown type");
                            }
                        }
                        prf.format(out, objectToSave, SaveProfileAction.this.pm);
                    }
                    catch (Exception ex) {
                        ASUtils.showExceptionDialog(SaveProfileAction.this.parent, "Could not generate/save report file", ex, new ArchitectExceptionReportFactory());
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException ex) {
                            ASUtils.showExceptionDialog(SaveProfileAction.this.parent, "Could not close report file", ex, new ArchitectExceptionReportFactory());
                        }
                    }
                }
            }
        };
        new Thread(saveTask).start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SaveableFileType {
        HTML,
        PDF,
        CSV;

    }
}

