/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.LockedColumnException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class DeleteSelectedAction
extends AbstractAction
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(DeleteSelectedAction.class);
    protected PlayPen pp;
    protected DBTree dbt;

    public DeleteSelectedAction() {
        super("Delete Selected", ASUtils.createJLFIcon("general/Delete", "Delete Selected", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Delete Selected");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        this.putValue("ActionCommandKey", "PlayPen");
        this.setEnabled(false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent evt) {
        block35: {
            block36: {
                block33: {
                    block34: {
                        DeleteSelectedAction.logger.debug((Object)"delete action detected!");
                        DeleteSelectedAction.logger.debug((Object)("ACTION COMMAND: " + evt.getActionCommand()));
                        if (!evt.getActionCommand().equals("PlayPen")) break block33;
                        DeleteSelectedAction.logger.debug((Object)"delete action came from playpen");
                        items = this.pp.getSelectedItems();
                        if (items.size() < 1) {
                            JOptionPane.showMessageDialog(this.pp, "No items to delete!");
                        }
                        if (items.size() <= 1) break block34;
                        tCount = this.pp.getSelectedTables().size();
                        var4_9 = this.pp.getSelectedRelationShips().size();
                        decision = JOptionPane.showConfirmDialog(this.pp, "Are you sure you want to delete these " + tCount + " tables and " + var4_9 + " relationships?", "Multiple Delete", 0);
                        if (decision != 0) {
                            return;
                        }
                        break block35;
                    }
                    deletingColumns = false;
                    var4_10 = items.get(0);
                    if (!(var4_10 instanceof TablePane)) break block36;
                    tp = (TablePane)var4_10;
                    selectedColumns = null;
                    try {
                        selectedColumns = tp.getSelectedColumns();
                        if (selectedColumns.size() > 0) {
                            deletingColumns = true;
                        }
                    }
                    catch (ArchitectException ae) {
                        JOptionPane.showMessageDialog(this.pp, ae.getMessage());
                        return;
                    }
                    try {
                        this.pp.startCompoundEdit("Delete");
                        it2 = selectedColumns.iterator();
                        if (true) ** GOTO lbl65
                    }
                    catch (Throwable var11_35) {
                        this.pp.endCompoundEdit("Ending multi-select");
                        throw var11_35;
                    }
                }
                if (!evt.getActionCommand().equals("DBTree")) {
                    DeleteSelectedAction.logger.debug((Object)"delete action came from unknown source, so we do nothing.");
                    return;
                }
                DeleteSelectedAction.logger.debug((Object)"delete action came from dbtree");
                selections = this.dbt.getSelectionPaths();
                if (selections.length > 1 && (decision = JOptionPane.showConfirmDialog(this.dbt, "Are you sure you want to delete the " + selections.length + " selected items?", "Multiple Delete", 0)) == 1) {
                    return;
                }
                this.pp.startCompoundEdit("Delete");
                try {
                    it = Arrays.asList(selections).iterator();
                    if (true) ** GOTO lbl125
                }
                catch (Throwable var10_34) {
                    this.pp.endCompoundEdit("Ending multi-select");
                    this.setEnabled(false);
                    throw var10_34;
                }
                do {
                    sc = it2.next();
                    try {
                        tp.getModel().removeColumn(sc);
                    }
                    catch (LockedColumnException ex) {
                        decision = JOptionPane.showConfirmDialog(this.pp, "Could not delete the column " + sc.getName() + " because it is part of\n" + "the relationship \"" + ex.getLockingRelationship() + "\".\n\n" + "Continue deleting remaining selected columns?", "Column is Locked", 0);
                        if (decision != 1) continue;
                        this.pp.endCompoundEdit("Ending multi-select");
                        return;
                    }
                    catch (ArchitectException e) {
                        DeleteSelectedAction.logger.error((Object)("Unexpected exception encountered when attempting to delete column '" + sc + "' of table '" + sc.getParentTable() + "'"));
                        ASUtils.showExceptionDialog(this.pp, "Could not delete the column", e, new ArchitectExceptionReportFactory());
                    }
lbl65:
                    // 4 sources

                } while (it2.hasNext());
                this.pp.endCompoundEdit("Ending multi-select");
            }
            if (deletingColumns) {
                return;
            }
        }
        this.pp.startCompoundEdit("Delete");
        try {
            for (PlayPenComponent ppc : items) {
                ppc.setSelected(false);
            }
            for (Selectable var4_13 : items) {
                DeleteSelectedAction.logger.debug((Object)("next item for delete is: " + var4_13.getClass().getName()));
                if (var4_13 instanceof TablePane) {
                    tp = (TablePane)var4_13;
                    this.pp.getDatabase().removeChild(tp.getModel());
                    continue;
                }
                if (var4_13 instanceof Relationship) {
                    r = (Relationship)var4_13;
                    DeleteSelectedAction.logger.debug((Object)("trying to delete relationship " + r));
                    sr = r.getModel();
                    sr.getPkTable().removeExportedKey(sr);
                    continue;
                }
                JOptionPane.showMessageDialog((JComponent)var4_13, "The selected item type is not recognised");
            }
            return;
        }
        finally {
            this.pp.endCompoundEdit("Ending multi-select");
        }
        do {
            if ((so = (SQLObject)(var4_14 = it.next()).getLastPathComponent()) instanceof SQLTable) {
                st = (SQLTable)so;
                this.pp.getDatabase().removeChild(st);
                this.pp.getTablePanes().remove(st.getName().toLowerCase());
                continue;
            }
            if (so instanceof SQLColumn) {
                sc = (SQLColumn)so;
                st = sc.getParentTable();
                try {
                    st.removeColumn(sc);
                }
                catch (LockedColumnException ex) {
                    decision = JOptionPane.showConfirmDialog(this.dbt, "Could not delete the column " + sc.getName() + " because it is part of a relationship key.  Continue" + " deleting of other selected items?", "Column is Locked", 0);
                    if (decision != 1) ** GOTO lbl125
                    this.pp.endCompoundEdit("Ending multi-select");
                    this.setEnabled(false);
                    return;
                }
                catch (ArchitectException e) {
                    DeleteSelectedAction.logger.error((Object)("Unexpected exception encountered when attempting to delete column '" + sc + "' of table '" + sc.getParentTable() + "'"));
                    ASUtils.showExceptionDialog(this.pp, "Encountered a Problem Deleting the column", e, new ArchitectExceptionReportFactory());
                }
            } else {
                if (so instanceof SQLRelationship) {
                    sr = (SQLRelationship)so;
                    sr.getPkTable().removeExportedKey(sr);
                    sr.getFkTable().removeImportedKey(sr);
                    continue;
                }
                JOptionPane.showMessageDialog(this.dbt, "The selected SQLObject type is not recognised: " + so.getClass().getName());
            }
lbl125:
            // 7 sources

        } while (it.hasNext());
        this.pp.endCompoundEdit("Ending multi-select");
        this.setEnabled(false);
    }

    public void setPlayPen(PlayPen newPP) throws ArchitectException {
        if (this.pp != null) {
            this.pp.removeSelectionListener(this);
        }
        this.pp = newPP;
        this.pp.addSelectionListener(this);
        this.setupAction(this.pp.getSelectedItems());
    }

    public void setDBTree(DBTree newDBT) {
        this.dbt = newDBT;
    }

    public void itemSelected(SelectionEvent e) {
        try {
            this.setupAction(this.pp.getSelectedItems());
        }
        catch (ArchitectException e1) {
            throw new ArchitectRuntimeException(e1);
        }
    }

    public void itemDeselected(SelectionEvent e) {
        try {
            this.setupAction(this.pp.getSelectedItems());
        }
        catch (ArchitectException e1) {
            throw new ArchitectRuntimeException(e1);
        }
    }

    private void setupAction(List selectedItems) throws ArchitectException {
        if (selectedItems.size() == 0) {
            this.setEnabled(false);
            this.putValue("ShortDescription", "Delete Selected");
        } else if (selectedItems.size() == 1) {
            String name;
            block13: {
                Selectable item = (Selectable)selectedItems.get(0);
                this.setEnabled(true);
                name = "Selected";
                if (item instanceof TablePane) {
                    TablePane tp = (TablePane)item;
                    if (tp.getSelectedColumnIndex() >= 0) {
                        try {
                            List<SQLColumn> selectedColumns = tp.getSelectedColumns();
                            if (selectedColumns.size() > 1) {
                                name = String.valueOf(selectedColumns.size()) + " items";
                                break block13;
                            }
                            name = tp.getModel().getColumn(tp.getSelectedColumnIndex()).getName();
                        }
                        catch (ArchitectException ex) {
                            logger.error((Object)"Couldn't get selected column name", (Throwable)ex);
                        }
                    } else {
                        name = tp.getModel().getName();
                    }
                } else if (item instanceof Relationship) {
                    name = ((Relationship)item).getModel().getName();
                }
            }
            this.putValue("ShortDescription", "Delete " + name);
        } else {
            this.setEnabled(true);
            int numSelectedItems = 0;
            for (Object item : selectedItems) {
                ++numSelectedItems;
                if (!(item instanceof TablePane)) continue;
                numSelectedItems += Math.max(((TablePane)item).getSelectedColumns().size() - 1, 0);
            }
            this.putValue("ShortDescription", "Delete " + numSelectedItems + " items");
        }
    }
}

