/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CreateRelationshipAction
extends AbstractAction
implements ActionListener,
SelectionListener,
PlayPen.CancelableListener {
    private static final Logger logger = Logger.getLogger(CreateRelationshipAction.class);
    protected boolean identifying;
    protected PlayPen pp;
    protected TablePane pkTable;
    protected TablePane fkTable;
    protected boolean active;

    public CreateRelationshipAction(boolean identifying) {
        super(identifying ? "New Identifying Relationship" : "New Non-Identifying Relationship", ASUtils.createIcon(identifying ? "NewIdentifyingRelationship" : "NewNonIdentifyingRelationship", "New Relationship", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        if (identifying) {
            this.putValue("ShortDescription", "New Identifying Relationship");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 0));
        } else {
            this.putValue("ShortDescription", "New Non-Identifying Relationship");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 1));
        }
        this.identifying = identifying;
        this.setEnabled(false);
        logger.debug((Object)("(constructor) hashcode is: " + super.hashCode()));
    }

    public void actionPerformed(ActionEvent evt) {
        this.pp.fireCancel();
        this.pkTable = null;
        this.fkTable = null;
        logger.debug((Object)"Starting to create relationship, setting active to TRUE!");
        this.active = true;
        this.pp.setCursor(Cursor.getPredefinedCursor(1));
        this.pp.selectNone();
    }

    public static void doCreateRelationship(SQLTable pkTable, SQLTable fkTable, PlayPen pp, boolean identifying) {
        try {
            try {
                pp.startCompoundEdit("Add Relationship");
                fkTable.setMagicEnabled(false);
                SQLRelationship model = new SQLRelationship();
                model.setName(String.valueOf(pkTable.getName()) + "_" + fkTable.getName() + "_fk");
                model.setIdentifying(identifying);
                model.attachRelationship(pkTable, fkTable, true);
                Relationship r = new Relationship(pp, model);
                pp.addRelationship(r);
                r.revalidate();
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Couldn't create relationship", (Throwable)ex);
                JOptionPane.showMessageDialog(pp, "Couldn't create relationship: " + ex.getMessage());
            }
        }
        finally {
            fkTable.setMagicEnabled(true);
            pp.endCompoundEdit("Ending the creation of a relationship");
        }
    }

    public void setPlayPen(PlayPen playpen) {
        if (this.pp != null) {
            this.pp.removeSelectionListener(this);
            this.pp.removeCancelableListener(this);
        }
        this.pp = playpen;
        if (this.pp != null) {
            this.pp.addSelectionListener(this);
            this.pp.addCancelableListener(this);
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void itemSelected(SelectionEvent e) {
        if (!this.active) {
            return;
        }
        Selectable s = e.getSelectableSource();
        if (!s.isSelected()) {
            return;
        }
        if (s instanceof TablePane) {
            if (this.pkTable == null) {
                this.pkTable = (TablePane)s;
                logger.debug((Object)("Creating relationship: PK Table is " + this.pkTable));
            } else {
                this.fkTable = (TablePane)s;
                logger.debug((Object)("Creating relationship: FK Table is " + this.fkTable));
                try {
                    CreateRelationshipAction.doCreateRelationship(this.pkTable.getModel(), this.fkTable.getModel(), this.pp, this.identifying);
                }
                finally {
                    this.resetAction();
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("The user clicked on a non-table component: " + s));
        }
    }

    private void resetAction() {
        this.pkTable = null;
        this.fkTable = null;
        this.pp.setCursor(null);
        this.active = false;
    }

    public void itemDeselected(SelectionEvent e) {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void cancel() {
        this.resetAction();
    }
}

