/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

public class SQLType {
    protected String name;
    protected int type;
    protected static final SQLType[] TYPES = new SQLType[]{new SQLType("ARRAY", 2003), new SQLType("BIGINT", -5), new SQLType("BINARY", -2), new SQLType("BIT", -7), new SQLType("BLOB", 2004), new SQLType("CHAR", 1), new SQLType("CLOB", 2005), new SQLType("DATE", 91), new SQLType("DECIMAL", 3), new SQLType("DISTINCT", 2001), new SQLType("DOUBLE", 8), new SQLType("FLOAT", 6), new SQLType("INTEGER", 4), new SQLType("JAVA_OBJECT", 2000), new SQLType("LONGVARBINARY", -4), new SQLType("LONGVARCHAR", -1), new SQLType("NULL", 0), new SQLType("NUMERIC", 2), new SQLType("OTHER", 1111), new SQLType("REAL", 7), new SQLType("REF", 2006), new SQLType("SMALLINT", 5), new SQLType("STRUCT", 2002), new SQLType("TIME", 92), new SQLType("TIMESTAMP", 93), new SQLType("TINYINT", -6), new SQLType("VARBINARY", -3), new SQLType("VARCHAR", 12)};

    public SQLType(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public static SQLType[] getTypes() {
        return TYPES;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public static String getTypeName(int typecode) {
        SQLType type = SQLType.getType(typecode);
        if (type == null) {
            return "Unknown Type " + typecode;
        }
        return type.getName();
    }

    protected static SQLType getType(int typecode) {
        int i = 0;
        while (i < TYPES.length) {
            if (SQLType.TYPES[i].type == typecode) {
                return TYPES[i];
            }
            ++i;
        }
        return null;
    }
}

