/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class RelationshipEditPanel
extends JPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(RelationshipEditPanel.class);
    protected SQLRelationship relationship;
    protected JTextField relationshipName;
    protected ButtonGroup identifyingGroup;
    protected JRadioButton identifyingButton;
    protected JRadioButton nonIdentifyingButton;
    protected JLabel pkTableName;
    protected ButtonGroup pkTypeGroup;
    protected JRadioButton pkTypeZeroToMany;
    protected JRadioButton pkTypeOneToMany;
    protected JRadioButton pkTypeZeroOne;
    protected JRadioButton pkTypeOne;
    protected JLabel fkTableName;
    protected ButtonGroup fkTypeGroup;
    protected JRadioButton fkTypeZeroToMany;
    protected JRadioButton fkTypeOneToMany;
    protected JRadioButton fkTypeZeroOne;
    protected LinkedList<UndoCompoundEventListener> undoEventListeners = new LinkedList();

    public RelationshipEditPanel() {
        super(new BorderLayout());
        this.addUndoEventListener(ArchitectFrame.getMainInstance().getUndoManager().getEventAdapter());
        JPanel topPanel = new JPanel(new FormLayout());
        topPanel.add(new JLabel("Relationship Name"));
        this.relationshipName = new JTextField();
        topPanel.add(this.relationshipName);
        topPanel.add(new JLabel("Relationship Type"));
        JPanel typePanel = new JPanel();
        this.identifyingGroup = new ButtonGroup();
        this.identifyingButton = new JRadioButton("Identifying");
        typePanel.add(this.identifyingButton);
        this.identifyingGroup.add(this.identifyingButton);
        this.nonIdentifyingButton = new JRadioButton("Non-Identifying");
        typePanel.add(this.nonIdentifyingButton);
        this.identifyingGroup.add(this.nonIdentifyingButton);
        topPanel.add(typePanel);
        this.add((Component)topPanel, "North");
        JPanel pkPanel = new JPanel(new FormLayout());
        pkPanel.setBorder(new TitledBorder("Primary Key End"));
        pkPanel.add(new JLabel("PK Table"));
        this.pkTableName = new JLabel("Unknown");
        pkPanel.add(this.pkTableName);
        this.pkTypeGroup = new ButtonGroup();
        pkPanel.add(new JLabel(""));
        this.pkTypeZeroToMany = new JRadioButton("Zero or More");
        pkPanel.add(this.pkTypeZeroToMany);
        this.pkTypeGroup.add(this.pkTypeZeroToMany);
        pkPanel.add(new JLabel("Cardinality"));
        this.pkTypeOneToMany = new JRadioButton("One or More");
        pkPanel.add(this.pkTypeOneToMany);
        this.pkTypeGroup.add(this.pkTypeOneToMany);
        pkPanel.add(new JLabel(""));
        this.pkTypeZeroOne = new JRadioButton("Zero or One");
        pkPanel.add(this.pkTypeZeroOne);
        this.pkTypeGroup.add(this.pkTypeZeroOne);
        pkPanel.add(new JLabel(""));
        this.pkTypeOne = new JRadioButton("Exactly One");
        pkPanel.add(this.pkTypeOne);
        this.pkTypeGroup.add(this.pkTypeOne);
        this.add((Component)pkPanel, "West");
        JPanel fkPanel = new JPanel(new FormLayout());
        fkPanel.setBorder(new TitledBorder("Foreign Key End"));
        fkPanel.add(new JLabel("FK Table"));
        this.fkTableName = new JLabel("Unknown");
        fkPanel.add(this.fkTableName);
        this.fkTypeGroup = new ButtonGroup();
        fkPanel.add(new JLabel(""));
        this.fkTypeZeroToMany = new JRadioButton("Zero or More");
        fkPanel.add(this.fkTypeZeroToMany);
        this.fkTypeGroup.add(this.fkTypeZeroToMany);
        fkPanel.add(new JLabel("Cardinality"));
        this.fkTypeOneToMany = new JRadioButton("One or More");
        fkPanel.add(this.fkTypeOneToMany);
        this.fkTypeGroup.add(this.fkTypeOneToMany);
        fkPanel.add(new JLabel(""));
        this.fkTypeZeroOne = new JRadioButton("Zero or One");
        fkPanel.add(this.fkTypeZeroOne);
        this.fkTypeGroup.add(this.fkTypeZeroOne);
        this.add((Component)fkPanel, "East");
    }

    public void setRelationship(SQLRelationship r) {
        this.relationship = r;
        this.relationshipName.setText(r.getName());
        this.pkTableName.setText(this.relationship.getPkTable().getName());
        this.fkTableName.setText(this.relationship.getFkTable().getName());
        if (r.isIdentifying()) {
            this.identifyingButton.setSelected(true);
        } else {
            this.nonIdentifyingButton.setSelected(true);
        }
        int pkc = r.getPkCardinality();
        if (pkc == 7) {
            this.pkTypeZeroToMany.setSelected(true);
        } else if (pkc == 3) {
            this.pkTypeZeroOne.setSelected(true);
        } else if (pkc == 6) {
            this.pkTypeOneToMany.setSelected(true);
        } else if (pkc == 2) {
            this.pkTypeOne.setSelected(true);
        }
        int fkc = r.getFkCardinality();
        if (fkc == 7) {
            this.fkTypeZeroToMany.setSelected(true);
        } else if (fkc == 3) {
            this.fkTypeZeroOne.setSelected(true);
        } else if (fkc == 6) {
            this.fkTypeOneToMany.setSelected(true);
        }
    }

    public boolean applyChanges() {
        this.startCompoundEdit("Relationship Properties Change");
        try {
            this.relationship.setName(this.relationshipName.getText());
            try {
                this.relationship.setIdentifying(this.identifyingButton.isSelected());
            }
            catch (ArchitectException ex) {
                logger.warn((Object)"Call to setIdentifying failed. Continuing with other properties.", (Throwable)ex);
            }
            if (this.pkTypeZeroOne.isSelected()) {
                this.relationship.setPkCardinality(3);
            } else if (this.pkTypeZeroToMany.isSelected()) {
                this.relationship.setPkCardinality(7);
            } else if (this.pkTypeOneToMany.isSelected()) {
                this.relationship.setPkCardinality(6);
            } else if (this.pkTypeOne.isSelected()) {
                this.relationship.setPkCardinality(2);
            }
            if (this.fkTypeZeroOne.isSelected()) {
                this.relationship.setFkCardinality(3);
            } else if (this.fkTypeZeroToMany.isSelected()) {
                this.relationship.setFkCardinality(7);
            } else if (this.fkTypeOneToMany.isSelected()) {
                this.relationship.setFkCardinality(6);
            }
        }
        finally {
            this.endCompoundEdit("Ending new compound edit event in relationship edit panel");
        }
        return true;
    }

    public void discardChanges() {
    }

    public void addUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.add(l);
    }

    public void removeUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.remove(l);
    }

    /*
     * Unable to fully structure code
     */
    protected void fireUndoCompoundEvent(UndoCompoundEvent e) {
        block2: {
            it = this.undoEventListeners.iterator();
            if (!e.getType().isStartEvent()) ** GOTO lbl8
            while (it.hasNext()) {
                ((UndoCompoundEventListener)it.next()).compoundEditStart(e);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                ((UndoCompoundEventListener)it.next()).compoundEditEnd(e);
lbl8:
                // 2 sources

                ** while (it.hasNext())
            }
        }
    }

    public void startCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, message));
    }

    public void endCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, message));
    }

    public JPanel getPanel() {
        return this;
    }
}

