/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.etl.PLUtils;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.DatabaseSelector;
import ca.sqlpower.architect.swingui.PLExportPanel;
import ca.sqlpower.architect.swingui.TextPanel;
import ca.sqlpower.architect.swingui.event.DatabaseComboBoxListener;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class PLExportXMLPanel
extends JPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(PLExportPanel.class);
    protected PLExport plexp;
    private JProgressBar progressBar = new JProgressBar();
    private JLabel label = new JLabel();
    protected JTextField xmlFileName;
    protected JTextField plFolderName;
    protected JTextField plJobId;
    protected JTextField plJobDescription;
    protected JTextField plJobComment;
    protected DatabaseComboBoxListener dcl;
    protected DatabaseSelector repository;
    protected Timer timer;
    protected String plDotIniPath;
    protected Map ddlGeneratorMap;
    protected TextPanel mainForm;

    public PLExportXMLPanel() {
        this.label.setText("");
        this.progressBar.setVisible(false);
        this.label.setVisible(false);
        this.repository = new DatabaseSelector(this.progressBar, this.label, this.getPanel());
        this.plFolderName = new JTextField();
        this.plJobId = new JTextField();
        this.plJobDescription = new JTextField();
        this.plJobComment = new JTextField();
        this.xmlFileName = new JTextField();
        FormLayout layout = new FormLayout("10dlu, 80dlu,10dlu, 5dlu,fill:100dlu:grow, 10dlu, 40dlu,30dlu", "4dlu, 20dlu, 1dlu, 20dlu, 1dlu, 20dlu, 4dlu, 20dlu,1dlu, 20dlu, 1dlu, 20dlu,4dlu, 20dlu, 1dlu, 20dlu, 1dlu, 20dlu, 1dlu, 20dlu,4dlu, 20dlu,4dlu, 20dlu");
        PanelBuilder pb = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        int row = 0;
        row = 2;
        pb.add((Component)new JLabel("Repository Connection"), cc.xy(2, row, "r,c"));
        pb.add((Component)this.repository.getConnectionsBox(), cc.xyw(4, row, 2));
        pb.add((Component)this.repository.getNewButton(), cc.xy(7, row));
        pb.add((Component)new JLabel("Repository Catalog"), cc.xy(2, row += 2, "r,c"));
        pb.add((Component)this.repository.getCatalogBox(), cc.xyw(4, row, 2));
        pb.add((Component)new JLabel("Repository Schema"), cc.xy(2, row += 2, "r,c"));
        pb.add((Component)this.repository.getSchemaBox(), cc.xyw(4, row, 2));
        pb.add((Component)new JLabel("PL Folder Name"), cc.xy(2, row += 2, "r,c"));
        pb.add((Component)this.plFolderName, cc.xyw(4, row, 2));
        pb.add((Component)new JLabel("PL Job Id"), cc.xy(2, row += 2, "r,c"));
        pb.add((Component)this.plJobId, cc.xyw(4, row, 2));
        pb.add((Component)new JLabel("PL Job Description"), cc.xy(2, row += 2, "r,c"));
        pb.add((Component)this.plJobDescription, cc.xyw(4, row, 2));
        pb.add((Component)new JLabel("PL Job Comment"), cc.xy(2, row += 2, "r,c"));
        pb.add((Component)this.plJobComment, cc.xyw(4, row, 2));
        pb.add((Component)new JLabel("File Name"), cc.xy(2, row += 4, "r,c"));
        pb.add((Component)this.xmlFileName, cc.xyw(4, row, 2));
        pb.add((Component)new JButton(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int response;
                JFileChooser chooser = new JFileChooser();
                chooser.addChoosableFileFilter(ASUtils.XML_FILE_FILTER);
                File file = null;
                do {
                    if ((response = chooser.showSaveDialog(PLExportXMLPanel.this)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file.getPath().endsWith(".xml")) continue;
                    file = new File(String.valueOf(file.getPath()) + ".xml");
                } while (file.exists() && (response = JOptionPane.showConfirmDialog(PLExportXMLPanel.this, "The file\n\n" + file.getPath() + "\n\nalready exists. Do you want to overwrite it?", "File Exists", 0)) == 1);
                PLExportXMLPanel.this.xmlFileName.setText(file.getPath());
            }
        }), cc.xy(6, row));
        pb.add((Component)this.label, cc.xy(2, 24, "r,c"));
        pb.add((Component)this.progressBar, cc.xyw(4, 24, 2));
        this.add(pb.getPanel());
    }

    public void setPLExport(PLExport plexp) {
        this.plexp = plexp;
        this.repository.getConnectionsBox().setSelectedItem(plexp.getRepositoryDataSource());
        this.plFolderName.setText(plexp.getFolderName());
        this.plJobId.setText(plexp.getJobId());
        this.plJobDescription.setText(plexp.getJobDescription());
        this.plJobComment.setText(plexp.getJobComment());
    }

    public PLExport getPLExport() {
        return this.plexp;
    }

    public boolean applyChanges() {
        logger.debug((Object)"Applying changes @ PLExportXMLPanel");
        if (this.plJobId.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "You have to specify the PowerLoader Job ID.", "Error", 0);
            return false;
        }
        if (this.xmlFileName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "You have to specify the XML File Name.", "Error", 0);
            return false;
        }
        this.plJobId.setText(PLUtils.toPLIdentifier(this.plJobId.getText()));
        this.plexp.setJobId(this.plJobId.getText());
        this.plFolderName.setText(PLUtils.toPLIdentifier(this.plFolderName.getText()));
        this.plexp.setFolderName(this.plFolderName.getText());
        this.plexp.setJobDescription(this.plJobDescription.getText());
        this.plexp.setJobComment(this.plJobComment.getText());
        File file = new File(this.xmlFileName.getText());
        this.plexp.setFile(file);
        this.plexp.setRepositoryDataSource((ArchitectDataSource)this.repository.getConnectionsBox().getSelectedItem());
        if (this.repository.getSchemaBox().isEnabled()) {
            this.plexp.setRepositorySchema(this.repository.getSchemaBox().getSelectedItem().toString());
        }
        if (this.repository.getCatalogBox().isEnabled()) {
            this.plexp.setRepositoryCatalog(this.repository.getCatalogBox().getSelectedItem().toString());
        }
        if (this.plexp.getRepositoryDataSource() == null) {
            JOptionPane.showMessageDialog(this, "You have to select a Repository database from the list.", "Error", 0);
            return false;
        }
        return true;
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this;
    }
}

