/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLExceptionNode;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.DBCSPanel;
import ca.sqlpower.architect.swingui.DBConnectionCallBack;
import ca.sqlpower.architect.swingui.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.DBTreeModel;
import ca.sqlpower.architect.swingui.DnDTreePathTransferable;
import ca.sqlpower.architect.swingui.MultiDragTreeUI;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.DBCSOkAction;
import ca.sqlpower.architect.swingui.action.ProfilePanelAction;
import ca.sqlpower.architect.swingui.action.SetDataSourceAction;
import java.awt.Cursor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTree
extends JTree
implements DragSourceListener,
DBConnectionCallBack {
    static Logger logger = Logger.getLogger(DBTree.class);
    protected DragSource ds;
    protected JPopupMenu popup;
    protected JMenu connectionsMenu;
    protected DBCSPanel dbcsPanel;
    protected NewDBCSAction newDBCSAction;
    protected DBCSPropertiesAction dbcsPropertiesAction;
    protected RemoveDBCSAction removeDBCSAction;
    protected ShowInPlayPenAction showInPlayPenAction;
    private ProfilePanelAction profileSelectionAction;
    protected SetConnAsTargetDB setConnAsTargetDB;
    protected SQLDatabase edittingDB;
    protected boolean panelHoldsNewDBCS;

    private DBTree() {
        this.setUI(new MultiDragTreeUI());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.ds = new DragSource();
        this.ds.createDefaultDragGestureRecognizer(this, 1, new DBTreeDragGestureListener());
        this.setConnAsTargetDB = new SetConnAsTargetDB(null);
        this.newDBCSAction = new NewDBCSAction();
        this.dbcsPropertiesAction = new DBCSPropertiesAction();
        this.removeDBCSAction = new RemoveDBCSAction();
        this.showInPlayPenAction = new ShowInPlayPenAction();
        this.addMouseListener(new PopupListener());
        this.setCellRenderer(new DBTreeCellRenderer());
    }

    public DBTree(List<SQLDatabase> initialDatabases, ProfileManager profileManager) throws ArchitectException {
        this();
        this.setDatabaseList(initialDatabases);
        this.profileSelectionAction = new ProfilePanelAction();
        this.profileSelectionAction.setDBTree(this);
        this.profileSelectionAction.setProfileManager(profileManager);
    }

    public void setDatabaseList(List<SQLDatabase> databases) throws ArchitectException {
        this.setModel(new DBTreeModel(databases));
    }

    public List getDatabaseList() {
        ArrayList<Object> databases = new ArrayList<Object>();
        TreeModel m = this.getModel();
        int dbCount = m.getChildCount(m.getRoot());
        int i = 0;
        while (i < dbCount) {
            databases.add(m.getChild(m.getRoot(), i));
            ++i;
        }
        return databases;
    }

    public boolean dbcsAlreadyExists(ArchitectDataSource spec) throws ArchitectException {
        SQLObject so = (SQLObject)this.getModel().getRoot();
        Iterator it = so.getChildren().iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            ArchitectDataSource dbcs = ((SQLDatabase)it.next()).getDataSource();
            if (spec != dbcs) continue;
            found = true;
        }
        return found;
    }

    public ArchitectDataSource getDuplicateDbcs(ArchitectDataSource spec) {
        ArchitectDataSource dup = null;
        boolean found = false;
        Iterator<ArchitectDataSource> it = ArchitectFrame.getMainInstance().getUserSettings().getConnections().iterator();
        while (it.hasNext() && !found) {
            ArchitectDataSource dbcs = it.next();
            if (!spec.equals(dbcs)) continue;
            dup = dbcs;
            found = true;
        }
        return dup;
    }

    public int[] getDnDPathToNode(SQLObject node) {
        DBTreeModel m = (DBTreeModel)this.getModel();
        SQLObject[] sop = m.getPathToNode(node);
        int[] dndp = new int[sop.length - 1];
        SQLObject current = sop[0];
        int i = 1;
        while (i < sop.length) {
            dndp[i - 1] = m.getIndexOfChild(current, sop[i]);
            current = sop[i];
            ++i;
        }
        return dndp;
    }

    public SQLObject getNodeForDnDPath(int[] path) throws ArchitectException {
        SQLObject current = (SQLObject)this.getModel().getRoot();
        int i = 0;
        while (i < path.length) {
            current = current.getChild(path[i]);
            ++i;
        }
        return current;
    }

    public int getRowForNode(SQLObject node) {
        DBTreeModel m = (DBTreeModel)this.getModel();
        TreePath path = new TreePath(m.getPathToNode(node));
        return this.getRowForPath(path);
    }

    @Override
    public void expandPath(TreePath tp) {
        try {
            try {
                ArchitectFrame.getMainInstance().setCursor(new Cursor(3));
                super.expandPath(tp);
            }
            catch (Exception ex) {
                logger.warn((Object)("Unexpected exception while expanding path " + tp), (Throwable)ex);
            }
        }
        finally {
            ArchitectFrame.getMainInstance().setCursor(null);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        logger.debug((Object)"DBTree: got dragEnter event");
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        logger.debug((Object)"DBTree: got dragOver event");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        logger.debug((Object)"DBTree: got dropActionChanged event");
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        logger.debug((Object)"DBTree: got dragExit event");
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        logger.debug((Object)"DBTree: got dragDropEnd event");
    }

    protected JPopupMenu refreshMenu(TreePath p) {
        JMenuItem popupProperties;
        logger.debug((Object)"refreshMenu is being called.");
        JPopupMenu newMenu = new JPopupMenu();
        this.connectionsMenu = new JMenu("Add Source Connection");
        newMenu.add(this.connectionsMenu);
        this.connectionsMenu.add(new JMenuItem(this.newDBCSAction));
        this.connectionsMenu.addSeparator();
        if (this.getSelectionPaths() != null) {
            newMenu.add(new JMenuItem(this.profileSelectionAction));
            this.profileSelectionAction.setDialog(ArchitectFrame.getMainInstance().getProject().getProfileDialog());
        }
        for (ArchitectDataSource dbcs : ArchitectFrame.getMainInstance().getUserSettings().getConnections()) {
            this.connectionsMenu.add(new JMenuItem(new AddDBCSAction(dbcs)));
        }
        ASUtils.breakLongMenu(ArchitectFrame.getMainInstance(), this.connectionsMenu);
        if (this.isTargetDatabaseNode(p)) {
            newMenu.addSeparator();
            this.connectionsMenu = new JMenu("Set Target Database");
            newMenu.add(this.connectionsMenu);
            if (ArchitectFrame.getMainInstance().getUserSettings().getConnections().size() == 0) {
                this.connectionsMenu.setEnabled(false);
            } else {
                SQLDatabase ppdb = ArchitectFrame.getMainInstance().getProject().getPlayPen().getDatabase();
                for (ArchitectDataSource dbcs : ArchitectFrame.getMainInstance().getUserSettings().getConnections()) {
                    this.connectionsMenu.add(new JMenuItem(new SetDataSourceAction(ppdb, dbcs)));
                }
                ASUtils.breakLongMenu(ArchitectFrame.getMainInstance(), this.connectionsMenu);
            }
            popupProperties = new JMenuItem(this.dbcsPropertiesAction);
            newMenu.add(popupProperties);
        } else if (this.isTargetDatabaseChild(p)) {
            newMenu.addSeparator();
            ArchitectFrame af = ArchitectFrame.getMainInstance();
            JMenuItem mi = new JMenuItem();
            mi.setAction(af.editColumnAction);
            mi.setActionCommand("DBTree");
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLColumn) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            mi = new JMenuItem();
            mi.setAction(af.insertColumnAction);
            mi.setActionCommand("DBTree");
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable || p.getLastPathComponent() instanceof SQLColumn) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            newMenu.addSeparator();
            mi = new JMenuItem();
            mi.setAction(this.showInPlayPenAction);
            newMenu.add(mi);
            mi = new JMenuItem();
            mi.setAction(af.editTableAction);
            mi.setActionCommand("DBTree");
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable || p.getLastPathComponent() instanceof SQLColumn) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            mi = new JMenuItem();
            mi.setAction(af.editRelationshipAction);
            mi.setActionCommand("DBTree");
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLRelationship) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            mi = new JMenuItem();
            mi.setAction(af.deleteSelectedAction);
            mi.setActionCommand("DBTree");
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable || p.getLastPathComponent() instanceof SQLColumn || p.getLastPathComponent() instanceof SQLRelationship) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
        } else if (p != null) {
            newMenu.addSeparator();
            if (p.getLastPathComponent() instanceof SQLDatabase) {
                newMenu.add(new JMenuItem(this.removeDBCSAction));
            }
            popupProperties = new JMenuItem(this.dbcsPropertiesAction);
            newMenu.add(popupProperties);
            if (p.getLastPathComponent() instanceof SQLDatabase) {
                SQLDatabase tempDB = (SQLDatabase)p.getLastPathComponent();
                JMenuItem setAsDB = new JMenuItem(new SetConnAsTargetDB(tempDB.getDataSource()));
                newMenu.add(setAsDB);
            }
        }
        if (p != null && p.getLastPathComponent() instanceof SQLExceptionNode) {
            newMenu.addSeparator();
            final SQLExceptionNode node = (SQLExceptionNode)p.getLastPathComponent();
            newMenu.add(new JMenuItem(new AbstractAction("Show Exception Details"){

                public void actionPerformed(ActionEvent e) {
                    ASUtils.showExceptionDialogNoReport("Exception Node Report", node.getException());
                }
            }));
            try {
                final SQLObject parent = node.getParent();
                if (parent.getChildCount() == 1) {
                    newMenu.add(new JMenuItem(new AbstractAction("Retry"){

                        public void actionPerformed(ActionEvent e) {
                            parent.removeChild(0);
                            parent.setPopulated(false);
                            try {
                                parent.getChildren();
                            }
                            catch (ArchitectException ex) {
                                try {
                                    parent.addChild(new SQLExceptionNode(ex, "New exception during retry"));
                                }
                                catch (ArchitectException e1) {
                                    logger.error((Object)"Couldn't add SQLExceptionNode to menu:", (Throwable)e1);
                                    JOptionPane.showMessageDialog(null, "Failed to add SQLExceptionNode:\n" + e1.getMessage());
                                }
                                ASUtils.showExceptionDialogNoReport("Exception occurred during retry", ex);
                            }
                        }
                    }));
                }
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Couldn't count siblings of SQLExceptionNode", (Throwable)ex);
            }
        }
        if (logger.isDebugEnabled()) {
            newMenu.addSeparator();
            JMenuItem showListeners = new JMenuItem("Show Listeners");
            showListeners.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SQLObject so = (SQLObject)DBTree.this.getLastSelectedPathComponent();
                    if (so != null) {
                        JOptionPane.showMessageDialog(DBTree.this, new JScrollPane(new JList<SQLObjectListener>(new Vector<SQLObjectListener>(so.getSQLObjectListeners()))));
                    }
                }
            });
            newMenu.add(showListeners);
        }
        return newMenu;
    }

    protected boolean isTargetDatabaseNode(TreePath tp) {
        if (tp == null) {
            return false;
        }
        return ArchitectFrame.getMainInstance().getProject().getPlayPen().getDatabase() == tp.getLastPathComponent();
    }

    protected boolean isTargetDatabaseChild(TreePath tp) {
        if (tp == null) {
            return false;
        }
        Object[] oo = tp.getPath();
        int i = 0;
        while (i < oo.length) {
            if (ArchitectFrame.getMainInstance().getProject().getPlayPen().getDatabase() == oo[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void selectDBConnection(ArchitectDataSource ds) {
        AddDBCSAction act = new AddDBCSAction(ds);
        act.actionPerformed(null);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e, true);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e, false);
        }

        private void maybeShowPopup(MouseEvent e, boolean isPress) {
            TreePath p = DBTree.this.getPathForLocation(e.getX(), e.getY());
            if (e.isPopupTrigger()) {
                logger.debug((Object)("TreePath is: " + p));
                if (p != null) {
                    logger.debug((Object)("selected node object type is: " + p.getLastPathComponent().getClass().getName()));
                }
                if (DBTree.this.isTargetDatabaseChild(p)) {
                    if (!DBTree.this.isPathSelected(p)) {
                        DBTree.this.setSelectionPath(p);
                    }
                } else if (!DBTree.this.isPathSelected(p)) {
                    DBTree.this.setSelectionPath(p);
                }
                DBTree.this.popup = DBTree.this.refreshMenu(p);
                DBTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            } else if (p == null && !isPress && e.getButton() == 1) {
                DBTree.this.setSelectionPath(null);
            }
        }
    }

    protected class AddDBCSAction
    extends AbstractAction {
        protected ArchitectDataSource dbcs;

        public AddDBCSAction(ArchitectDataSource dbcs) {
            super(dbcs.getName());
            this.dbcs = dbcs;
        }

        public void actionPerformed(ActionEvent e) {
            SQLObject root = (SQLObject)DBTree.this.getModel().getRoot();
            try {
                if (DBTree.this.dbcsAlreadyExists(this.dbcs)) {
                    logger.warn((Object)"database already exists in this project.");
                    JOptionPane.showMessageDialog(DBTree.this, "Can't set connection " + this.dbcs.getDisplayName() + ".  It already exists in the current project.", "Warning", 2);
                } else {
                    SQLDatabase newDB = new SQLDatabase(this.dbcs);
                    root.addChild(root.getChildCount(), newDB);
                    ArchitectFrame.getMainInstance().getProject().setModified(true);
                    logger.debug((Object)("start poking database " + newDB.getName()));
                    PokeDBThread thread = new PokeDBThread(newDB);
                    thread.start();
                }
            }
            catch (ArchitectException ex) {
                logger.warn((Object)"Couldn't add new database to tree", (Throwable)ex);
                JOptionPane.showMessageDialog(DBTree.this, "Couldn't add new connection:\n" + ex.getMessage(), "Error", 0);
            }
        }
    }

    protected class SetConnAsTargetDB
    extends AbstractAction {
        ArchitectDataSource dbcs;

        public SetConnAsTargetDB(ArchitectDataSource dbcs) {
            super("Set As Target Database");
            this.dbcs = dbcs;
        }

        public void actionPerformed(ActionEvent e) {
            ArchitectFrame.getMainInstance().getProject().getPlayPen().setDatabaseConnection(this.dbcs);
        }
    }

    protected class NewDBCSAction
    extends AbstractAction {
        public NewDBCSAction() {
            super("New Connection...");
        }

        public void actionPerformed(ActionEvent e) {
            final DBCSPanel dbcsPanel = new DBCSPanel();
            ArchitectDataSource dbcs = new ArchitectDataSource();
            dbcsPanel.setDbcs(new ArchitectDataSource());
            DBCSOkAction okButton = new DBCSOkAction(dbcsPanel, true);
            okButton.setConnectionSelectionCallBack(DBTree.this);
            AbstractAction cancelAction = new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    dbcsPanel.discardChanges();
                }
            };
            JDialog d = ArchitectPanelBuilder.createArchitectPanelDialog(dbcsPanel, ArchitectFrame.getMainInstance(), "New Connection", "OK", okButton, cancelAction);
            okButton.setConnectionDialog(d);
            d.pack();
            d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
            d.setVisible(true);
            DBTree.this.edittingDB = new SQLDatabase(dbcs);
            DBTree.this.panelHoldsNewDBCS = true;
        }
    }

    protected class PokeDBThread
    extends Thread {
        SQLObject so;

        PokeDBThread(SQLObject so) {
            this.so = so;
        }

        public void run() {
            try {
                ArchitectUtils.pokeDatabase(this.so);
            }
            catch (ArchitectException ex) {
                logger.error((Object)("problem poking database " + this.so.getName()), (Throwable)ex);
            }
            logger.debug((Object)("finished poking database " + this.so.getName()));
        }
    }

    protected class RemoveDBCSAction
    extends AbstractAction {
        public RemoveDBCSAction() {
            super("Remove Connection");
        }

        public void actionPerformed(ActionEvent arg0) {
            TreePath tp = DBTree.this.getSelectionPath();
            if (tp == null) {
                JOptionPane.showMessageDialog(DBTree.this, "No items were selected.", "Can't remove", 2);
                return;
            }
            if (!(tp.getLastPathComponent() instanceof SQLDatabase)) {
                JOptionPane.showMessageDialog(DBTree.this, "The selection was not a database", "Can't remove", 2);
                return;
            }
            if (DBTree.this.isTargetDatabaseNode(tp)) {
                JOptionPane.showMessageDialog(DBTree.this, "You can't remove the target database", "Can't remove", 2);
                return;
            }
            try {
                SQLDatabase selection = (SQLDatabase)tp.getLastPathComponent();
                SQLObject root = (SQLObject)DBTree.this.getModel().getRoot();
                List dependants = ArchitectUtils.findColumnsSourcedFromDatabase(ArchitectFrame.getMainInstance().getProject().getTargetDatabase(), selection);
                if (dependants.size() > 0) {
                    JOptionPane.showMessageDialog(DBTree.this, new Object[]{"The following columns depend on objects in this database:", new JScrollPane(new JList<Object>(dependants.toArray())), "You can't remove this connection unless you remove these", "dependencies."}, "Can't delete", 1);
                } else if (root.removeChild(selection)) {
                    selection.disconnect();
                } else {
                    logger.error((Object)"root.removeChild(selection) returned false!");
                    JOptionPane.showMessageDialog(DBTree.this, "Deletion of this database connection failed for an unknown reason.", "Couldn't remove", 0);
                }
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Couldn't locate dependant columns", (Throwable)ex);
                JOptionPane.showMessageDialog(DBTree.this, "Couldn't search for dependant columns:\n" + ex.getMessage() + "\n\nDatabase connection not removed.", "Couldn't remove", 0);
            }
        }
    }

    protected class DBCSPropertiesAction
    extends AbstractAction {
        public DBCSPropertiesAction() {
            super("Connection Properties...");
        }

        public void actionPerformed(ActionEvent e) {
            TreePath p = DBTree.this.getSelectionPath();
            if (p == null) {
                return;
            }
            Object[] pathArray = p.getPath();
            int ii = 0;
            SQLDatabase sd = null;
            while (ii < pathArray.length && sd == null) {
                if (pathArray[ii] instanceof SQLDatabase) {
                    sd = (SQLDatabase)pathArray[ii];
                }
                ++ii;
            }
            if (sd != null) {
                final DBCSPanel dbcsPanel = new DBCSPanel();
                ArchitectDataSource dbcs = sd.getDataSource();
                dbcsPanel.setDbcs(dbcs);
                DBCSOkAction okButton = new DBCSOkAction(dbcsPanel, false);
                AbstractAction cancelAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent evt) {
                        dbcsPanel.discardChanges();
                    }
                };
                JDialog d = ArchitectPanelBuilder.createArchitectPanelDialog(dbcsPanel, ArchitectFrame.getMainInstance(), "Connection Properties", "OK", okButton, cancelAction);
                okButton.setConnectionDialog(d);
                d.pack();
                d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
                d.setVisible(true);
                logger.debug((Object)("Setting existing DBCS on panel: " + dbcs));
                DBTree.this.edittingDB = sd;
                dbcsPanel.setDbcs(dbcs);
            }
        }
    }

    protected class ShowInPlayPenAction
    extends AbstractAction {
        public ShowInPlayPenAction() {
            super("Show in Playpen");
        }

        public void actionPerformed(ActionEvent e) {
            TreePath p = DBTree.this.getSelectionPath();
            if (p == null) {
                return;
            }
            PlayPen pp = ArchitectFrame.getMainInstance().playpen;
            SQLObject selection = (SQLObject)p.getLastPathComponent();
            if (selection instanceof SQLColumn) {
                SQLColumn col = (SQLColumn)selection;
                SQLTable table = col.getParentTable();
                TablePane tp = pp.findTablePane(table);
                pp.selectAndShow(table);
                try {
                    tp.columnSelection.set(table.getColumnIndex(col), Boolean.TRUE);
                }
                catch (ArchitectException e1) {
                    ASUtils.showExceptionDialog("Error in selecting the column!", e1);
                }
            } else {
                pp.selectAndShow(selection);
            }
        }
    }

    public static class DBTreeDragGestureListener
    implements DragGestureListener {
        public void dragGestureRecognized(DragGestureEvent dge) {
            logger.info((Object)("Drag gesture event: " + dge));
            InputEvent ie = dge.getTriggerEvent();
            if ((ie.getModifiers() & 0x10) == 0) {
                return;
            }
            DBTree t = (DBTree)dge.getComponent();
            TreePath[] p = t.getSelectionPaths();
            if (p == null || p.length == 0) {
                return;
            }
            ArrayList<int[]> paths = new ArrayList<int[]>(p.length);
            int i = 0;
            while (i < p.length) {
                if (t.getDnDPathToNode((SQLObject)p[i].getLastPathComponent())[0] != 0) {
                    paths.add(t.getDnDPathToNode((SQLObject)p[i].getLastPathComponent()));
                }
                ++i;
            }
            logger.info((Object)"DBTree: exporting list of DnD-type tree paths");
            dge.getDragSource().startDrag(dge, null, new DnDTreePathTransferable(paths), t);
        }
    }
}

